/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.border.SoftBevelBorder;

public class AboutDialog
extends JDialog
implements ActionListener {
    public static String vcid = "$Id: AboutDialog.java,v 1.1.1.1 2002/01/15 19:48:45 hendriks73 Exp $";
    private static ResourceBundle localStrings = ResourceBundle.getBundle("com.tagtraum.perf.gcviewer.localStrings");
    private static final String GCVIEWER_HOMEPAGE = "http://www.tagtraum.com/";
    private Frame frame;

    public AboutDialog(Frame f) {
        super(f, localStrings.getString("about_dialog_title"), true);
        this.frame = f;
        this.setLocation(20, 20);
        Panel panel0 = new Panel();
        ImageIcon logoIcon = new ImageIcon(this.getClass().getResource(localStrings.getString("about_dialog_image")));
        JLabel la_icon = new JLabel(logoIcon);
        la_icon.setBorder(new SoftBevelBorder(1));
        panel0.add(la_icon);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(2));
        if (ExternalViewer.isSupported()) {
            try {
                JButton homepageButton = new JButton("Homepage");
                homepageButton.addActionListener(new ExternalViewer(new URL(GCVIEWER_HOMEPAGE)));
                panel2.add(homepageButton);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        JButton okButton = new JButton(localStrings.getString("button_ok"));
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        panel2.add(okButton);
        this.getContentPane().add("North", panel0);
        this.getContentPane().add("South", panel2);
        this.pack();
        this.setResizable(false);
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ok")) {
            this.setVisible(false);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocation((int)this.frame.getLocation().getX() + this.frame.getWidth() / 2 - this.getWidth() / 2, (int)this.frame.getLocation().getY() + this.frame.getHeight() / 2 - this.getHeight() / 2);
        }
        super.setVisible(visible);
    }

    private static class ExternalViewer
    implements ActionListener {
        private static final boolean WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("win");
        private static final boolean MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
        private static final String MAC_PATH = "open";
        private static final String WIN_PATH = "rundll32";
        private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
        private URL url;

        public ExternalViewer(URL url) {
            this.url = url;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExternalViewer.displayURL(this.url);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }

        public static void displayURL(URL url) throws IOException {
            String cmd = null;
            String urlString = url.toString();
            if (WINDOWS) {
                if (urlString.startsWith("file:/") && !urlString.startsWith("file://")) {
                    urlString = "file://" + urlString.substring("file:/".length());
                }
                try {
                    urlString = URLDecoder.decode(urlString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cmd = "rundll32 url.dll,FileProtocolHandler " + urlString;
                Runtime.getRuntime().exec(cmd);
            } else if (MAC) {
                cmd = urlString.endsWith(".jsp") || urlString.endsWith(".jspx") ? "open -e " + urlString.substring("file:".length()) : "open " + url;
                Runtime.getRuntime().exec(cmd);
            }
        }

        public static boolean isSupported() {
            return WINDOWS || MAC;
        }
    }
}

