/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.DataWriter;
import com.tagtraum.perf.gcviewer.exp.CSVDataWriter;
import com.tagtraum.perf.gcviewer.exp.PlainDataWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;

public class DataWriterFactory {
    private static ResourceBundle localStrings = ResourceBundle.getBundle("com.tagtraum.perf.gcviewer.localStrings");

    public DataWriter getDataWriter(File file, String extension) throws IOException {
        if (extension.equals(".csv")) {
            return new CSVDataWriter(new FileOutputStream(file));
        }
        if (extension.equals(".txt")) {
            return new PlainDataWriter(new FileOutputStream(file));
        }
        throw new IOException(localStrings.getString("datawriterfactory_instantiation_failed") + " " + file);
    }
}

