/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.GCViewer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;

public class DesktopPane
extends JDesktopPane {
    private ImageIcon logoIcon = new ImageIcon(GCViewer.class.getResource("gcviewer_background.png"));

    public DesktopPane(final GCViewer gcViewer) {
        gcViewer.setDropTarget(new DropTarget(this, 1, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent e) {
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.acceptDrag(1);
                } else {
                    e.rejectDrag();
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            public void dragExit(DropTargetEvent dte) {
            }

            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        e.acceptDrop(1);
                        List list = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                        File[] files = list.toArray(new File[list.size()]);
                        gcViewer.open(files);
                        e.dropComplete(true);
                    } else {
                        e.rejectDrop();
                    }
                }
                catch (IOException ioe) {
                    e.rejectDrop();
                    ioe.printStackTrace();
                }
                catch (UnsupportedFlavorException ufe) {
                    e.rejectDrop();
                    ufe.printStackTrace();
                }
            }
        }));
    }

    public void paint(Graphics g) {
        Rectangle r = g.getClipBounds();
        g.setColor(Color.WHITE);
        if (r != null) {
            g.fillRect(r.x, r.y, r.width, r.height);
        } else {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.drawImage(this.logoIcon.getImage(), this.getWidth() / 2 - this.logoIcon.getIconWidth() / 2, this.getHeight() / 2 - this.logoIcon.getIconHeight() / 2, this.logoIcon.getIconWidth(), this.logoIcon.getIconHeight(), this.logoIcon.getImageObserver());
        super.paint(g);
    }

    public boolean isOpaque() {
        return false;
    }
}

