/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;

public class GCEvent
extends AbstractGCEvent {
    private int preUsed;
    private int postUsed;
    private int total;
    private double pause;

    public GCEvent() {
    }

    public GCEvent(double timestamp, int preUsed, int postUsed, int total, double pause, AbstractGCEvent.Type type) {
        this.setTimestamp(timestamp);
        this.preUsed = preUsed;
        this.postUsed = postUsed;
        this.total = total;
        this.pause = pause;
        this.setType(type);
    }

    public void setPreUsed(int preUsed) {
        this.preUsed = preUsed;
    }

    public void setPostUsed(int postUsed) {
        this.postUsed = postUsed;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setPause(double pause) {
        this.pause = pause;
    }

    public boolean isFull() {
        return this.getType() == AbstractGCEvent.Type.FULL_GC || this.getType().getGeneration() == AbstractGCEvent.Generation.TENURED || this.hasTenuredDetail();
    }

    public boolean isInc() {
        return this.getType() == AbstractGCEvent.Type.INC_GC;
    }

    public double getPause() {
        return this.pause;
    }

    public int getPreUsed() {
        return this.preUsed;
    }

    public int getPostUsed() {
        return this.postUsed;
    }

    public int getTotal() {
        return this.total;
    }

    public void toStringBuffer(StringBuffer sb) {
        sb.append(this.getTimestamp());
        sb.append(": [");
        sb.append(this.getType());
        sb.append(' ');
        if (this.details != null) {
            int length = this.details.size();
            for (int i = 0; i < length; ++i) {
                AbstractGCEvent event = (AbstractGCEvent)this.details.get(i);
                event.toStringBuffer(sb);
            }
        }
        sb.append(this.preUsed);
        sb.append("K->");
        sb.append(this.postUsed);
        sb.append("K(");
        sb.append(this.total);
        sb.append("K), ");
        sb.append(this.pause);
        sb.append(" secs]");
    }
}

