/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer;

import com.tagtraum.perf.gcviewer.GCDocument;
import com.tagtraum.perf.gcviewer.GCViewer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class RefreshWatchDog {
    private GCDocument gcDocument;
    private javax.swing.Timer animationTimer;
    private Timer reloadTimer;
    private Action action;
    public static final ImageIcon WATCH_ICON = new ImageIcon(Toolkit.getDefaultToolkit().getImage(GCViewer.class.getResource("images/watch.png")));
    private static final ImageIcon CLOCK_ICON = new ImageIcon(Toolkit.getDefaultToolkit().getImage(GCViewer.class.getResource("images/clock.png")));
    private static final int ANIMATION_DELAY = 250;
    private static final int RELOAD_DELAY = 1000;

    public GCDocument getGcDocument() {
        return this.gcDocument;
    }

    public void setGcDocument(GCDocument gcDocument) {
        this.gcDocument = gcDocument;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void start() {
        this.animationTimer = new javax.swing.Timer(250, new ClockAnimation());
        this.reloadTimer = new Timer(true);
        this.reloadTimer.schedule((TimerTask)new ModelReloader(), 0L, 1000L);
        this.action.putValue("SmallIcon", CLOCK_ICON);
        this.animationTimer.start();
    }

    public void stop() {
        if (this.reloadTimer != null) {
            this.reloadTimer.cancel();
        }
        if (this.animationTimer != null && this.animationTimer.isRunning()) {
            this.animationTimer.stop();
        }
        if (this.action != null) {
            this.action.putValue("SmallIcon", WATCH_ICON);
        }
    }

    private class ModelReloader
    extends TimerTask {
        private ModelReloader() {
        }

        public void run() {
            try {
                if (RefreshWatchDog.this.gcDocument.reloadModels(true)) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            RefreshWatchDog.this.gcDocument.relayout();
                        }
                    });
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private class ClockAnimation
    implements ActionListener {
        private int clockIndex;

        private ClockAnimation() {
        }

        public void actionPerformed(ActionEvent e) {
            if (RefreshWatchDog.this.action != null) {
                // empty if block
            }
        }
    }
}

