/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.action;

import com.tagtraum.perf.gcviewer.GCViewer;
import com.tagtraum.perf.gcviewer.util.ExtensionFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class OpenFile
extends AbstractAction {
    private GCViewer gcViewer;
    private JFileChooser openDialog;
    private File[] lastSelectedFiles = new File[0];
    private JCheckBox addURLCheckBox;

    public OpenFile(GCViewer gcViewer) {
        this.gcViewer = gcViewer;
        this.putValue("Name", GCViewer.localStrings.getString("main_frame_menuitem_open_file"));
        this.putValue("ShortDescription", GCViewer.localStrings.getString("main_frame_menuitem_hint_open_file"));
        this.putValue("MnemonicKey", new Integer(GCViewer.localStrings.getString("main_frame_menuitem_mnemonic_open_file").charAt(0)));
        this.putValue("ActionCommandKey", "open");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().getImage(gcViewer.getClass().getResource("images/open.png"))));
        this.openDialog = new JFileChooser();
        this.openDialog.setDialogTitle(GCViewer.localStrings.getString("fileopen_dialog_title"));
        this.openDialog.setMultiSelectionEnabled(true);
        this.openDialog.addChoosableFileFilter(ExtensionFileFilter.GcExtensionFilter);
        this.openDialog.addChoosableFileFilter(ExtensionFileFilter.TxtExtensionFilter);
        this.openDialog.addChoosableFileFilter(ExtensionFileFilter.LogExtensionFilter);
        this.addURLCheckBox = new JCheckBox(GCViewer.localStrings.getString("fileopen_dialog_add_checkbox"), false);
        this.addURLCheckBox.setVerticalTextPosition(1);
        this.addURLCheckBox.setToolTipText(GCViewer.localStrings.getString("fileopen_dialog_hint_add_checkbox"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 2.0;
        panel.add((Component)this.addURLCheckBox, gridBagConstraints);
        this.openDialog.setAccessory(panel);
    }

    public void actionPerformed(ActionEvent e) {
        boolean aDocumentIsAlreadyOpen = this.gcViewer.getSelectedGCDocument() != null;
        this.addURLCheckBox.setVisible(aDocumentIsAlreadyOpen);
        this.addURLCheckBox.setEnabled(aDocumentIsAlreadyOpen);
        int val = this.openDialog.showOpenDialog(this.gcViewer);
        if (val == 0) {
            this.lastSelectedFiles = this.openDialog.getSelectedFiles();
            if (this.addURLCheckBox.isSelected()) {
                this.gcViewer.add(this.lastSelectedFiles);
            } else {
                this.gcViewer.open(this.lastSelectedFiles);
            }
        }
    }

    public void setSelectedFile(File file) {
        this.openDialog.setCurrentDirectory(file.getParentFile());
        this.openDialog.setSelectedFile(file);
    }

    public File[] getLastSelectedFiles() {
        return this.lastSelectedFiles;
    }
}

