/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.action;

import com.tagtraum.perf.gcviewer.GCDocument;
import com.tagtraum.perf.gcviewer.GCViewer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class Watch
extends AbstractAction {
    private GCViewer gcViewer;
    private static final ImageIcon WATCH_ICON = new ImageIcon(Toolkit.getDefaultToolkit().getImage(GCViewer.class.getResource("images/watch.png")));

    public Watch(GCViewer gcViewer) {
        this.gcViewer = gcViewer;
        this.putValue("Name", GCViewer.localStrings.getString("main_frame_menuitem_watch"));
        this.putValue("ShortDescription", GCViewer.localStrings.getString("main_frame_menuitem_hint_watch"));
        this.putValue("MnemonicKey", new Integer(GCViewer.localStrings.getString("main_frame_menuitem_mnemonic_watch").charAt(0)));
        this.putValue("ActionCommandKey", "watch");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 2));
        this.putValue("SmallIcon", WATCH_ICON);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent ae) {
        AbstractButton source = (AbstractButton)ae.getSource();
        if (source.isSelected()) {
            GCDocument selectedGCDocument = this.gcViewer.getSelectedGCDocument();
            selectedGCDocument.setWatched(true);
            selectedGCDocument.getRefreshWatchDog().setAction(this);
            selectedGCDocument.getRefreshWatchDog().start();
        } else {
            GCDocument selectedGCDocument = this.gcViewer.getSelectedGCDocument();
            selectedGCDocument.setWatched(false);
            selectedGCDocument.getRefreshWatchDog().stop();
        }
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        if (!newValue) {
            this.putValue("SmallIcon", WATCH_ICON);
        }
    }
}

