/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.exp;

import com.tagtraum.perf.gcviewer.DataWriter;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;

public class CSVDataWriter
implements DataWriter {
    private PrintWriter out;

    public CSVDataWriter(OutputStream out) {
        this.out = new PrintWriter(new OutputStreamWriter(out));
    }

    private void writeHeader() {
        this.out.println("Timestamp(sec/#),Used(K),Total(K),Pause(sec),GC-Type");
    }

    public void write(GCModel model) throws IOException {
        this.writeHeader();
        Iterator i = model.getGCEvents();
        while (i.hasNext()) {
            GCEvent event = (GCEvent)i.next();
            if (model.hasCorrectTimestamp()) {
                this.out.print(event.getTimestamp() - event.getPause());
            } else {
                this.out.print(event.getTimestamp());
            }
            this.out.print(',');
            this.out.print(event.getPreUsed());
            this.out.print(',');
            this.out.print(event.getTotal());
            this.out.print(',');
            this.out.print(event.getPause());
            this.out.print(',');
            this.out.println(event.getType());
            this.out.print(event.getTimestamp());
            this.out.print(',');
            this.out.print(event.getPostUsed());
            this.out.print(',');
            this.out.print(event.getTotal());
            this.out.print(',');
            this.out.print(0);
            this.out.print(',');
            this.out.println("NONE");
        }
        this.out.flush();
    }

    public void close() {
        if (this.out != null) {
            this.out.close();
        }
    }
}

