/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.imp.ParseException;
import com.tagtraum.perf.gcviewer.util.NumberParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.logging.Logger;

public abstract class AbstractDataReaderSun {
    private static Logger LOG = Logger.getLogger(AbstractDataReaderSun.class.getName());
    protected BufferedReader in;

    public AbstractDataReaderSun(InputStream in) throws UnsupportedEncodingException {
        this.in = new BufferedReader(new InputStreamReader(in, "ASCII"), 65536);
    }

    public void setMemoryAndPauses(GCEvent event, String line) throws ParseException {
        this.setMemoryAndPauses(event, line, new ParsePosition(0));
    }

    public void setMemoryAndPauses(GCEvent event, String line, ParsePosition pos) throws ParseException {
        boolean foundPreUsed;
        int start = pos.getIndex();
        int end = line.indexOf("K->", pos.getIndex());
        if (end != -1) {
            for (start = end - 1; start >= 0 && Character.isDigit(line.charAt(start)); --start) {
            }
        }
        int parenthesis = line.indexOf(40, start);
        boolean bl = foundPreUsed = end != -1 && parenthesis > end;
        if (foundPreUsed) {
            start = line.lastIndexOf(32, end) + 1;
            event.setPreUsed(NumberParser.parseInt(line, start, end - start));
            start = end + 3;
        }
        end = line.indexOf(75, start);
        event.setPostUsed(NumberParser.parseInt(line, start, end - start));
        if (!foundPreUsed) {
            event.setPreUsed(event.getPostUsed());
        }
        start = end + 2;
        end = line.indexOf(75, start);
        event.setTotal(NumberParser.parseInt(line, start, end - start));
        if (line.charAt(end + 1) == ')') {
            pos.setIndex(end + 2);
        } else {
            pos.setIndex(end + 1);
        }
        while (this.isGeneration(line, pos)) {
            GCEvent detailEvent = new GCEvent();
            AbstractGCEvent.Type type = this.parseType(line, pos);
            detailEvent.setType(type);
            start = pos.getIndex();
            end = line.indexOf("K", pos.getIndex());
            detailEvent.setPreUsed(NumberParser.parseInt(line, start, end - start));
            start = end + 3;
            end = line.indexOf("K", start);
            detailEvent.setPostUsed(NumberParser.parseInt(line, start, end - start));
            if (line.charAt(end + 1) == '(') {
                start = end + 2;
                end = line.indexOf(75, start);
                detailEvent.setTotal(NumberParser.parseInt(line, start, end - start));
                ++end;
            }
            detailEvent.setTimestamp(event.getTimestamp());
            if (detailEvent.getPreUsed() > detailEvent.getPostUsed()) {
                event.add(detailEvent);
            }
            pos.setIndex(end + 1);
        }
        int openingBracket = line.indexOf(91, pos.getIndex());
        if (openingBracket == pos.getIndex() + 3 || openingBracket == pos.getIndex() + 2) {
            pos.setIndex(openingBracket);
        } else if (line.indexOf(44, pos.getIndex()) == pos.getIndex()) {
            pos.setIndex(pos.getIndex() + 2);
            this.setPause(event, line, pos);
        } else if (line.indexOf("icms_dc=", pos.getIndex()) != -1) {
            int comma = line.indexOf(44, pos.getIndex());
            pos.setIndex(comma + 2);
            this.setPause(event, line, pos);
        } else {
            int closingBracket = line.indexOf(93, pos.getIndex());
            if (closingBracket == pos.getIndex()) {
                pos.setIndex(closingBracket + 1);
                if (line.charAt(closingBracket + 1) == ',') {
                    pos.setIndex(closingBracket + 3);
                } else {
                    pos.setIndex(closingBracket + 1);
                }
            } else {
                LOG.severe("Hm... something went wrong here...");
            }
        }
    }

    private boolean isGeneration(String line, ParsePosition pos) {
        String trimmedLine = line.substring(pos.getIndex()).trim();
        return trimmedLine.startsWith("eden") || trimmedLine.startsWith("survivor") || trimmedLine.startsWith("tenured") || trimmedLine.startsWith("new") || trimmedLine.startsWith("permanent");
    }

    public void setPause(GCEvent event, String line, ParsePosition pos) {
        int end = line.indexOf(32, pos.getIndex());
        event.setPause(Double.parseDouble(line.substring(pos.getIndex(), end).replace(',', '.')));
        pos.setIndex(line.indexOf(93, end) + 1);
    }

    protected boolean hasNextDetail(String line, ParsePosition pos) {
        return this.isTimestamp(line, pos) || this.nextCharIsBracket(line, pos);
    }

    protected boolean nextCharIsBracket(String line, ParsePosition pos) {
        while (line.charAt(pos.getIndex()) == ' ' && pos.getIndex() + 1 < line.length()) {
            pos.setIndex(pos.getIndex() + 1);
        }
        return line.charAt(pos.getIndex()) == '[';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractGCEvent.Type parseType(String line, ParsePosition pos) throws ParseException {
        int i = pos.getIndex();
        try {
            String type;
            int lineLength = line.length();
            char[] lineChars = line.toCharArray();
            char c = lineChars[i];
            while (i < lineLength && (c == ' ' || c == '[')) {
                c = lineChars[++i];
            }
            if (i >= lineLength) {
                throw new ParseException("Unexpected end of line.", line);
            }
            StringBuffer sb = new StringBuffer(20);
            int startNumbers = i;
            while (Character.isDigit(c) && i < lineLength) {
                c = lineChars[++i];
            }
            if (startNumbers != i) {
                sb.append(lineChars, startNumbers, i);
            }
            int startType = i;
            while (i < lineLength && c != ':' && c != '[' && c != ']' && !Character.isDigit(c)) {
                c = lineChars[++i];
            }
            sb.append(lineChars, startType, i - startType);
            while (i < lineLength && c != '[' && c != ']' && !Character.isDigit(c)) {
                c = lineChars[++i];
            }
            String s = sb.toString();
            AbstractGCEvent.Type gcType = AbstractGCEvent.Type.parse(s);
            if (gcType == null && (type = s.trim()).startsWith(AbstractGCEvent.Type.GC.getType()) && type.indexOf("Desired survivor") != -1) {
                i = line.indexOf("total", i);
                i += 5;
                gcType = AbstractGCEvent.Type.GC;
            }
            if (gcType == null) {
                throw new ParseException("Unknown GC type: " + s, line);
            }
            AbstractGCEvent.Type type2 = gcType;
            return type2;
        }
        finally {
            pos.setIndex(i);
        }
    }

    public boolean isTimestamp(String line, ParsePosition pos) {
        int colonIndex = line.indexOf(58, pos.getIndex());
        int kIndex = line.indexOf(75, pos.getIndex());
        if (colonIndex < 0) {
            return false;
        }
        if (kIndex < 0) {
            return true;
        }
        return colonIndex < kIndex;
    }

    public double parseTimestamp(String line, ParsePosition pos) throws ParseException {
        int endOfTimestamp = line.indexOf(58, pos.getIndex());
        if (endOfTimestamp == -1) {
            throw new ParseException("Error parsing entry.", line);
        }
        String timestampString = line.substring(pos.getIndex(), endOfTimestamp).replace(',', '.');
        double timestamp = Double.parseDouble(timestampString);
        pos.setIndex(endOfTimestamp + 1);
        return timestamp;
    }

    protected abstract AbstractGCEvent parseLine(String var1, ParsePosition var2) throws ParseException;

    public void skipDetails(String line, ParsePosition pos) throws ParseException {
        int index = line.lastIndexOf(93, line.length() - 2) + 1;
        if (index == 0) {
            throw new ParseException("Failed to skip details.", line);
        }
        if (line.charAt(index) == ' ') {
            ++index;
        }
        pos.setIndex(index);
    }
}

