/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.DataReader;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataReaderHPUX1_2
implements DataReader {
    private static Logger LOG = Logger.getLogger(DataReaderHPUX1_2.class.getName());
    private LineNumberReader in;

    public DataReaderHPUX1_2(InputStream in) {
        this.in = new LineNumberReader(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCModel read() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading HP-UX 1.2-1.4.0 format...");
        }
        try {
            GCModel model = new GCModel(true);
            model.setFormat(GCModel.Format.SUN_X_LOG_GC);
            String line = null;
            GCEvent event = null;
            while ((line = this.in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, " ");
                if (st.countTokens() != 20) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning("Malformed line (" + this.in.getLineNumber() + "). Wrong number of tokens (" + st.countTokens() + "): " + line);
                    continue;
                }
                if (!"<GC:".equals(st.nextToken())) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning("Malformed line (" + this.in.getLineNumber() + "). Expected \"<GC:\" in " + line);
                    continue;
                }
                event = new GCEvent();
                int reason = Integer.parseInt(st.nextToken());
                event.setType(AbstractGCEvent.Type.parse(reason));
                event.setTimestamp(Double.parseDouble(st.nextToken()));
                st.nextToken();
                st.nextToken();
                st.nextToken();
                long edenBefore = Long.parseLong(st.nextToken());
                long edenAfter = Long.parseLong(st.nextToken());
                long edenCapacity = Long.parseLong(st.nextToken());
                long survivorBefore = Long.parseLong(st.nextToken());
                long survivorAfter = Long.parseLong(st.nextToken());
                long survivorCapacity = Long.parseLong(st.nextToken());
                GCEvent newEvent = new GCEvent();
                newEvent.setType(AbstractGCEvent.Type.DEF_NEW);
                newEvent.setPreUsed((int)((survivorBefore + edenBefore) / 1024L));
                newEvent.setPostUsed((int)((survivorAfter + edenAfter) / 1024L));
                newEvent.setTotal((int)((survivorCapacity + edenCapacity) / 1024L));
                long oldBefore = Long.parseLong(st.nextToken());
                long oldAfter = Long.parseLong(st.nextToken());
                long oldCapacity = Long.parseLong(st.nextToken());
                GCEvent oldEvent = new GCEvent();
                oldEvent.setType(AbstractGCEvent.Type.TENURED);
                oldEvent.setPreUsed((int)(oldBefore / 1024L));
                oldEvent.setPostUsed((int)(oldAfter / 1024L));
                oldEvent.setTotal((int)(oldCapacity / 1024L));
                long permBefore = Long.parseLong(st.nextToken());
                long permAfter = Long.parseLong(st.nextToken());
                long permCapacity = Long.parseLong(st.nextToken());
                GCEvent permEvent = new GCEvent();
                permEvent.setType(AbstractGCEvent.Type.PERM);
                permEvent.setPreUsed((int)(permBefore / 1024L));
                permEvent.setPostUsed((int)(permAfter / 1024L));
                permEvent.setTotal((int)(permCapacity / 1024L));
                double pause = Double.parseDouble(st.nextToken());
                event.setPause(pause);
                event.setPreUsed(newEvent.getPreUsed() + oldEvent.getPreUsed());
                event.setPostUsed(newEvent.getPostUsed() + oldEvent.getPostUsed());
                event.setTotal(newEvent.getTotal() + oldEvent.getTotal());
                event.add(newEvent);
                if (event.getType() == AbstractGCEvent.Type.FULL_GC) {
                    event.add(oldEvent);
                }
                event.add(permEvent);
                model.add(event);
            }
            GCModel gCModel = model;
            return gCModel;
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {}
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Reading done.");
            }
        }
    }
}

