/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.DataReader;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataReaderJRockit1_4_2
implements DataReader {
    private static Logger LOG = Logger.getLogger(DataReaderJRockit1_4_2.class.getName());
    private LineNumberReader in;
    private static final String MEMORY_MARKER = "[memory ] ";
    private static final String NURSERY_SIZE = "nursery size: ";

    public DataReaderJRockit1_4_2(InputStream in) {
        this.in = new LineNumberReader(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCModel read() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading JRockit 1.4.2 format...");
        }
        boolean gcSummary = false;
        try {
            GCModel model = new GCModel(true);
            model.setFormat(GCModel.Format.SUN_X_LOG_GC);
            String line = null;
            GCEvent event = null;
            int nurserySize = -1;
            while ((line = this.in.readLine()) != null) {
                GCEvent detailEvent;
                int typeStart;
                int memoryIndex = line.indexOf(MEMORY_MARKER);
                if (memoryIndex == -1) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("Ignoring line " + this.in.getLineNumber() + ". Missing \"[memory ]\" marker: " + line);
                    continue;
                }
                if (line.endsWith(MEMORY_MARKER)) continue;
                int startTimeIndex = memoryIndex + MEMORY_MARKER.length();
                if (!gcSummary) {
                    gcSummary = line.endsWith("Memory usage report");
                }
                if (gcSummary) {
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.info(line.substring(startTimeIndex));
                    continue;
                }
                if (line.indexOf("Prefetch distance") != -1) {
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.info(line.substring(startTimeIndex));
                    continue;
                }
                if (line.indexOf("GC strategy") != -1) {
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.info(line.substring(startTimeIndex));
                    continue;
                }
                if (line.toLowerCase().indexOf("heap size:") != -1) {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info(line.substring(startTimeIndex));
                    }
                    int nurserySizeStart = line.indexOf(NURSERY_SIZE);
                    int nurserySizeEnd = line.indexOf(75, nurserySizeStart + NURSERY_SIZE.length());
                    if (nurserySizeStart == -1) continue;
                    nurserySize = Integer.parseInt(line.substring(nurserySizeStart + NURSERY_SIZE.length(), nurserySizeEnd));
                    continue;
                }
                if (line.substring(startTimeIndex).startsWith("<")) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine(line.substring(startTimeIndex));
                    continue;
                }
                int colon = line.indexOf(58, startTimeIndex);
                if (colon == -1) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning("Malformed line (" + this.in.getLineNumber() + "). Missing colon after start time: " + line);
                    continue;
                }
                event = new GCEvent();
                String timestampString = line.substring(startTimeIndex, colon);
                int minus = timestampString.indexOf(45);
                if (minus == -1) {
                    event.setTimestamp(Double.parseDouble(timestampString));
                } else {
                    event.setTimestamp(Double.parseDouble(timestampString.substring(0, minus)));
                }
                int typeEnd = typeStart = DataReaderJRockit1_4_2.skipSpaces(colon + 1, line);
                while (!Character.isDigit(line.charAt(++typeEnd))) {
                }
                AbstractGCEvent.Type type = AbstractGCEvent.Type.parse("jrockit." + line.substring(typeStart, typeEnd).trim());
                if (type == null) {
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.info("Failed to determine type: " + line.substring(startTimeIndex));
                    continue;
                }
                event.setType(type);
                int startBefore = typeEnd;
                int endBefore = line.indexOf(75, startBefore);
                event.setPreUsed(Integer.parseInt(line.substring(startBefore, endBefore)));
                int startAfter = endBefore + 3;
                int endAfter = line.indexOf(75, startAfter);
                event.setPostUsed(Integer.parseInt(line.substring(startAfter, endAfter)));
                int startTotal = line.indexOf(40, endAfter) + 1;
                int endTotal = line.indexOf(75, startTotal);
                event.setTotal(Integer.parseInt(line.substring(startTotal, endTotal)));
                int startPause = line.indexOf(44, endTotal) + 2;
                int endPause = line.indexOf(32, startPause);
                event.setPause(Double.parseDouble(line.substring(startPause, endPause)) / 1000.0);
                model.add(event);
                if (nurserySize != -1 && event.getType().getGeneration() == AbstractGCEvent.Generation.YOUNG) {
                    detailEvent = new GCEvent();
                    detailEvent.setType(event.getType());
                    detailEvent.setTimestamp(event.getTimestamp());
                    detailEvent.setTotal(nurserySize);
                    event.add(detailEvent);
                }
                if (nurserySize == -1 || event.getType().getGeneration() != AbstractGCEvent.Generation.TENURED) continue;
                detailEvent = new GCEvent();
                detailEvent.setType(event.getType());
                detailEvent.setTimestamp(event.getTimestamp());
                detailEvent.setTotal(event.getTotal() - nurserySize);
                event.add(detailEvent);
            }
            GCModel gCModel = model;
            return gCModel;
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {}
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Reading done.");
            }
        }
    }

    private static int skipSpaces(int start, String line) {
        int i = start;
        while (line.charAt(i) == ' ') {
            ++i;
        }
        return i;
    }
}

