/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.DataReader;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.imp.AbstractDataReaderSun;
import com.tagtraum.perf.gcviewer.imp.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataReaderSun1_3_1
extends AbstractDataReaderSun
implements DataReader {
    private static Logger LOG = Logger.getLogger(DataReaderSun1_3_1.class.getName());
    private int count;

    public DataReaderSun1_3_1(InputStream in) throws UnsupportedEncodingException {
        super(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCModel read() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading Sun 1.3.1 format...");
        }
        try {
            int i;
            this.count = 0;
            GCModel model = new GCModel(true);
            model.setFormat(GCModel.Format.SUN_VERBOSE_GC);
            ArrayList<StringBuffer> lineStack = new ArrayList<StringBuffer>();
            StringBuffer line = null;
            while ((i = this.in.read()) != -1) {
                char c = (char)i;
                if (c == '[') {
                    if (line != null) {
                        lineStack.add(line);
                    }
                    line = new StringBuffer(64);
                    continue;
                }
                if (c == ']') {
                    try {
                        model.add(this.parseLine(line.toString(), null));
                    }
                    catch (ParseException e) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, e.getMessage(), e);
                        }
                        System.out.println(e.getMessage());
                    }
                    if (lineStack.isEmpty()) continue;
                    line = (StringBuffer)lineStack.remove(lineStack.size() - 1);
                    continue;
                }
                if (line == null) continue;
                line.append(c);
            }
            GCModel gCModel = model;
            return gCModel;
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {}
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Done reading.");
            }
        }
    }

    protected AbstractGCEvent parseLine(String line, ParsePosition pos) throws ParseException {
        GCEvent event = new GCEvent();
        try {
            event.setTimestamp(this.count);
            ++this.count;
            StringTokenizer st = new StringTokenizer(line, " ,->()K\r\n");
            String token = st.nextToken();
            if (token.equals("Full") && st.nextToken().equals("GC")) {
                event.setType(AbstractGCEvent.Type.FULL_GC);
            } else if (token.equals("Inc") && st.nextToken().equals("GC")) {
                event.setType(AbstractGCEvent.Type.INC_GC);
            } else if (token.equals("GC")) {
                event.setType(AbstractGCEvent.Type.GC);
            } else {
                throw new ParseException("Error parsing entry: " + line);
            }
            this.setMemoryAndPauses(event, line);
            return event;
        }
        catch (RuntimeException rte) {
            ParseException parseException = new ParseException("Error parsing entry: " + line + ", " + rte.toString());
            parseException.initCause(rte);
            throw parseException;
        }
    }
}

