/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.imp;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.ConcurrentGCEvent;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.imp.DataReaderSun1_4_0;
import com.tagtraum.perf.gcviewer.imp.ParseException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataReaderSun1_5_0
extends DataReaderSun1_4_0 {
    private static Logger LOG = Logger.getLogger(DataReaderSun1_5_0.class.getName());

    public DataReaderSun1_5_0(InputStream in) throws UnsupportedEncodingException {
        super(in);
    }

    protected AbstractGCEvent parseLine(String line, ParsePosition pos) throws ParseException {
        AbstractGCEvent ae = null;
        try {
            double timestamp = this.parseTimestamp(line, pos);
            AbstractGCEvent.Type type = this.parseType(line, pos);
            if (type.getConcurrency() == AbstractGCEvent.Concurrency.CONCURRENT) {
                if (type.toString().endsWith("-start")) {
                    ConcurrentGCEvent event = new ConcurrentGCEvent();
                    event.setTimestamp(timestamp);
                    event.setType(type);
                    ae = event;
                } else {
                    ConcurrentGCEvent event = new ConcurrentGCEvent();
                    event.setTimestamp(timestamp);
                    event.setType(type);
                    int start = pos.getIndex();
                    int end = line.indexOf(47, pos.getIndex());
                    event.setPause(Double.parseDouble(line.substring(start, end)));
                    start = end + 1;
                    end = line.indexOf(32, start);
                    event.setDuration(Double.parseDouble(line.substring(start, end)));
                    ae = event;
                }
            } else {
                GCEvent detailEvent;
                GCEvent event;
                block17: {
                    event = new GCEvent();
                    event.setTimestamp(timestamp);
                    event.setType(type);
                    ParsePosition recoverPos = new ParsePosition(pos.getIndex());
                    try {
                        while (this.hasNextDetail(line, pos)) {
                            detailEvent = new GCEvent();
                            if (this.nextCharIsBracket(line, pos)) {
                                detailEvent.setTimestamp(timestamp);
                            } else {
                                detailEvent.setTimestamp(this.parseTimestamp(line, pos));
                            }
                            detailEvent.setType(this.parseType(line, pos));
                            this.setMemoryAndPauses(detailEvent, line, pos);
                            event.add(detailEvent);
                        }
                    }
                    catch (ParseException e) {
                        pos.setIndex(recoverPos.getIndex());
                        this.skipDetails(line, pos);
                        if (line.indexOf(AbstractGCEvent.Type.CMS_REMARK.getType()) != -1) {
                            ConcurrentGCEvent detailEvent2 = new ConcurrentGCEvent();
                            detailEvent2.setTimestamp(timestamp);
                            detailEvent2.setType(AbstractGCEvent.Type.CMS_REMARK);
                            event.add(detailEvent2);
                        }
                        if (!LOG.isLoggable(Level.INFO)) break block17;
                        LOG.info("Skipping details in line \"" + line + "\" because of " + e);
                    }
                }
                this.setMemoryAndPauses(event, line, pos);
                if (event.getPause() == 0.0) {
                    if (this.hasNextDetail(line, pos)) {
                        detailEvent = new GCEvent();
                        if (this.nextCharIsBracket(line, pos)) {
                            detailEvent.setTimestamp(timestamp);
                        } else {
                            detailEvent.setTimestamp(this.parseTimestamp(line, pos));
                        }
                        detailEvent.setType(this.parseType(line, pos));
                        this.setMemoryAndPauses(detailEvent, line, pos);
                        event.add(detailEvent);
                    }
                    this.setPause(event, line, pos);
                }
                ae = event;
            }
            return ae;
        }
        catch (RuntimeException rte) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, rte.toString() + " while parsing line: " + line, rte);
            }
            throw new ParseException("Error parsing entry: " + line + ", " + rte.toString());
        }
    }
}

