/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.log;

import com.tagtraum.perf.gcviewer.log.TextAreaFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextArea;

public class TextAreaLogHandler
extends Handler {
    private JTextArea textArea = new JTextArea();
    private boolean errors;

    public TextAreaLogHandler() {
        this.setFormatter(new TextAreaFormatter());
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public void publish(LogRecord record) {
        block7: {
            try {
                if (!this.isLoggable(record)) break block7;
                if (!this.errors) {
                    int level = record.getLevel().intValue();
                    this.errors = level >= Level.WARNING.intValue() && level < Level.OFF.intValue();
                }
                String formattedRecord = null;
                try {
                    formattedRecord = this.getFormatter().format(record);
                }
                catch (Exception e) {
                    this.reportError(e.toString(), e, 5);
                }
                try {
                    this.textArea.append(formattedRecord);
                }
                catch (Exception e) {
                    this.reportError(e.toString(), e, 1);
                }
            }
            catch (Exception e) {
                this.reportError(e.toString(), e, 0);
            }
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

