/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.renderer;

import com.tagtraum.perf.gcviewer.ChartRenderer;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.ModelChart;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;

public abstract class PolygonChartRenderer
extends ChartRenderer {
    private boolean drawPolygon;
    private Paint fillPaint;

    public PolygonChartRenderer(ModelChartImpl modelChart) {
        super(modelChart);
        this.setOpaque(false);
    }

    public void setDrawPolygon(boolean drawPolygon) {
        this.drawPolygon = drawPolygon;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public void paintComponent(Graphics2D g2d) {
        if (!this.drawPolygon && !this.isDrawLine()) {
            return;
        }
        Polygon polygon = this.computePolygon(this.getModelChart(), this.getModelChart().getModel());
        if (this.drawPolygon) {
            Object oldAAHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (this.isDrawLine()) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            g2d.setPaint(this.createPaint(polygon));
            g2d.fillPolygon(polygon);
            if (this.isDrawLine()) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
            }
        }
        if (this.isDrawLine()) {
            g2d.setPaint(this.getLinePaint());
            g2d.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints - 1);
        }
    }

    public abstract Polygon computePolygon(ModelChart var1, GCModel var2);

    protected Paint createPaint(Polygon polygon) {
        if (this.fillPaint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)this.fillPaint;
            Point point1 = new Point(0, PolygonChartRenderer.getLowestY(polygon));
            Point point2 = new Point(0, this.getHeight());
            return new GradientPaint(point1, gradientPaint.getColor1(), point2, gradientPaint.getColor2(), false);
        }
        return this.fillPaint;
    }

    protected ScaledPolygon createTimeScaledPolygon() {
        return new ScaledPolygon(this.getModelChart().getScaleFactor(), (double)this.getHeight() / this.getModelChart().getMaxPause(), this.getHeight());
    }

    protected ScaledPolygon createMemoryScaledPolygon() {
        return new ScaledPolygon(this.getModelChart().getScaleFactor(), (double)this.getHeight() / (double)this.getModelChart().getFootprint(), this.getHeight());
    }

    private static int getLowestY(Polygon polygon) {
        int[] y = polygon.ypoints;
        int min = Integer.MAX_VALUE;
        int max = polygon.npoints;
        for (int i = 0; i < max; ++i) {
            min = Math.min(min, y[i]);
        }
        return min;
    }

    public static class ScaledPolygon
    extends Polygon {
        private double xScaleFactor;
        private double yScaleFactor;
        private int yOffset;

        public ScaledPolygon(double xScaleFactor, double yScaleFactor, int yOffset) {
            this.xScaleFactor = xScaleFactor;
            this.yScaleFactor = yScaleFactor;
            this.yOffset = yOffset;
        }

        public void addPoint(double x, double y) {
            int scaledY = this.yOffset - (int)(this.yScaleFactor * y);
            int scaledX = (int)(this.xScaleFactor * x);
            int n = this.npoints;
            if (n > 2 && this.ypoints[n - 2] == scaledY && this.ypoints[n - 1] == this.ypoints[n - 2]) {
                this.xpoints[n - 1] = scaledX;
            } else {
                this.addPoint(scaledX, scaledY);
            }
        }
    }
}

