/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.renderer;

import com.tagtraum.perf.gcviewer.AbstractGCEvent;
import com.tagtraum.perf.gcviewer.GCEvent;
import com.tagtraum.perf.gcviewer.GCModel;
import com.tagtraum.perf.gcviewer.ModelChart;
import com.tagtraum.perf.gcviewer.ModelChartImpl;
import com.tagtraum.perf.gcviewer.renderer.PolygonChartRenderer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.util.Iterator;

public class TotalTenuredRenderer
extends PolygonChartRenderer {
    public static final Paint DEFAULT_LINEPAINT = Color.MAGENTA;
    public static final Paint DEFAULT_FILLPAINT = new GradientPaint(0.0f, 0.0f, Color.MAGENTA, 0.0f, 0.0f, Color.WHITE);

    public TotalTenuredRenderer(ModelChartImpl modelChart) {
        super(modelChart);
        this.setFillPaint(DEFAULT_FILLPAINT);
        this.setLinePaint(DEFAULT_LINEPAINT);
        this.setDrawPolygon(true);
        this.setDrawLine(true);
    }

    public Polygon computePolygon(ModelChart modelChart, GCModel model) {
        PolygonChartRenderer.ScaledPolygon polygon = this.createMemoryScaledPolygon();
        polygon.addPoint(0.0, 0.0);
        double lastTotal = 0.0;
        double fallback = 0.0;
        double lastTenuredTotal = 0.0;
        Iterator i = model.getGCEvents();
        while (i.hasNext()) {
            GCEvent event = (GCEvent)i.next();
            Iterator iterator = event.details();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof GCEvent)) continue;
                GCEvent detailEvent = (GCEvent)o;
                if (detailEvent.getType().getGeneration() == AbstractGCEvent.Generation.TENURED) {
                    double total = detailEvent.getTotal();
                    if (total == 0.0) {
                        total = lastTenuredTotal;
                    } else {
                        lastTenuredTotal = total;
                    }
                    if (polygon.npoints == 1) {
                        polygon.addPoint(0.0, total);
                        lastTotal = total;
                    }
                    if (lastTotal != total) {
                        polygon.addPoint(detailEvent.getTimestamp(), lastTotal);
                    }
                    polygon.addPoint(detailEvent.getTimestamp() + detailEvent.getPause(), total);
                    lastTotal = total;
                }
                if (detailEvent.getType().getGeneration() != AbstractGCEvent.Generation.YOUNG || fallback != 0.0) continue;
                fallback = event.getTotal() - detailEvent.getTotal();
            }
        }
        if (polygon.npoints == 1 && fallback != 0.0) {
            polygon.addPoint(0.0, fallback);
            lastTotal = fallback;
        }
        polygon.addPoint(model.getRunningTime(), lastTotal);
        polygon.addPoint(model.getRunningTime(), 0.0);
        return polygon;
    }
}

