/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.perf.gcviewer.util;

public class NumberParser {
    public static final int MAX_NEGATIVE_INTEGER_CHARS = Integer.toString(Integer.MIN_VALUE).length();
    public static final int MAX_POSITIVE_INTEGER_CHARS = Integer.toString(Integer.MAX_VALUE).length();
    public static final int MAX_NEGATIVE_LONG_CHARS = Long.toString(Long.MIN_VALUE).length();
    public static final int MAX_POSITIVE_LONG_CHARS = Long.toString(Long.MAX_VALUE).length();

    public static int parseInt(char[] cb, int offset, int length) throws NumberFormatException {
        if (cb == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        if (length > 0) {
            int limit;
            if (cb[offset] == '-') {
                if (length > MAX_NEGATIVE_INTEGER_CHARS) {
                    throw new NumberFormatException(new String(cb, offset, length));
                }
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                if (length > MAX_POSITIVE_INTEGER_CHARS) {
                    throw new NumberFormatException(new String(cb, offset, length));
                }
                limit = -2147483647;
            }
            while (i < length) {
                int digit;
                if ((digit = cb[offset + i++] - 48) < 0 || digit > 9) {
                    throw new NumberFormatException(new String(cb, offset, length));
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException(new String(cb, offset, length));
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException(new String(cb, offset, length));
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(new String(cb, offset, length));
        }
        return -result;
    }

    public static int parseInt(String s) throws NumberFormatException {
        return NumberParser.parseInt(s, 0, s.length());
    }

    public static int parseInt(String s, int offset, int length) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        if (length > 0) {
            int limit;
            if (s.charAt(offset) == '-') {
                if (length > MAX_NEGATIVE_INTEGER_CHARS) {
                    throw new NumberFormatException(s);
                }
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                if (length > MAX_POSITIVE_INTEGER_CHARS) {
                    throw new NumberFormatException(s);
                }
                limit = -2147483647;
            }
            while (i < length) {
                int digit;
                if ((digit = s.charAt(offset + i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException(s);
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException(s);
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException(s);
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    public static long parseLong(String s) throws NumberFormatException {
        return NumberParser.parseLong(s, 0, s.length());
    }

    public static long parseLong(String s, int offset, int length) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        if (length > 0) {
            long limit;
            if (s.charAt(offset) == '-') {
                if (length <= MAX_NEGATIVE_INTEGER_CHARS) {
                    return NumberParser.parseInt(s, offset, length);
                }
                if (length > MAX_NEGATIVE_LONG_CHARS) {
                    throw new NumberFormatException(s);
                }
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                if (length <= MAX_POSITIVE_INTEGER_CHARS) {
                    return NumberParser.parseInt(s, offset, length);
                }
                if (length > MAX_POSITIVE_LONG_CHARS) {
                    throw new NumberFormatException(s);
                }
                limit = -9223372036854775807L;
            }
            while (i < length) {
                int digit;
                if ((digit = s.charAt(offset + i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException(s);
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException(s);
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException(s);
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    public static long parseLong(char[] cb, int offset, int length) throws NumberFormatException {
        if (cb == null) {
            throw new NumberFormatException("null");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        if (length > 0) {
            long limit;
            if (cb[offset] == '-') {
                if (length <= MAX_NEGATIVE_INTEGER_CHARS) {
                    return NumberParser.parseInt(cb, offset, length);
                }
                if (length > MAX_NEGATIVE_LONG_CHARS) {
                    throw new NumberFormatException(new String(cb, offset, length));
                }
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                if (length <= MAX_POSITIVE_INTEGER_CHARS) {
                    return NumberParser.parseInt(cb, offset, length);
                }
                if (length > MAX_POSITIVE_LONG_CHARS) {
                    throw new NumberFormatException(new String(cb, offset, length));
                }
                limit = -9223372036854775807L;
            }
            while (i < length) {
                int digit;
                if ((digit = cb[offset + i++] - 48) < 0 || digit > 9) {
                    throw new NumberFormatException(new String(cb, offset, length));
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException(new String(cb, offset, length));
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException(new String(cb, offset, length));
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(new String(cb, offset, length));
        }
        return -result;
    }
}

