/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.sixbs;

import com.tagtraum.framework.util.EntityResolverImpl;
import com.tagtraum.sixbs.ObjectIdentifier;
import com.tagtraum.sixbs.SIXBSException;
import com.tagtraum.sixbs.VersionedContentHandlerWrapper;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SIXBSReader {
    public static String vcid = "$Id: SIXBSReader.java,v 1.5 2001/08/06 16:46:42 Hendrik Exp $";
    private static SAXParserFactory saxParserFactory;
    public static String DEFAULTVERSION;
    private boolean stillParsing = true;
    private ParseThread parseThread;
    private IOException pendingException;
    private InputSource inputSource;
    private ObjectIdentifier objectIdentifier;
    private List objects = new ArrayList();
    private Object lock = new Object();
    private int readAhead = 10;
    private String defaultVersion;
    private String version;
    private boolean validating = false;

    public SIXBSReader(Reader reader) throws IOException {
        this(reader, DEFAULTVERSION);
    }

    public SIXBSReader(InputStream inputStream) throws IOException {
        this(inputStream, DEFAULTVERSION);
    }

    public SIXBSReader(Reader reader, String string) throws IOException {
        this.inputSource = new InputSource(reader);
        this.init(string);
    }

    public SIXBSReader(InputStream inputStream, String string) throws IOException {
        this.inputSource = new InputSource(inputStream);
        this.init(string);
    }

    private void init(String string) {
        this.objectIdentifier = new ObjectIdentifier();
        this.defaultVersion = string;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String string) {
        this.version = string;
    }

    void setStillParsing(boolean bl) {
        this.stillParsing = bl;
    }

    public void setReadAhead(int n) {
        this.readAhead = n;
    }

    public int getReadAhead() {
        return this.readAhead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject() throws IOException {
        this.handlePendingException();
        this.checkThread();
        Object var1_1 = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                while (this.objects.size() == 0 && this.stillParsing) {
                    this.lock.wait(250L);
                    this.handlePendingException();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SIXBSException(interruptedException);
            }
            if (this.objects.size() <= 0) {
                throw new EOFException();
            }
            var1_1 = this.objects.remove(0);
            this.lock.notify();
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObject(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.objects.add(object);
            this.lock.notify();
            try {
                while (this.objects.size() > this.readAhead && this.stillParsing) {
                    this.lock.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        try {
            this.checkThread();
        }
        catch (SIXBSException sIXBSException) {
            this.setPendingException(sIXBSException);
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                while (this.objects.size() == 0 && this.stillParsing) {
                    this.lock.wait(75L);
                }
            }
            catch (InterruptedException interruptedException) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.objects.size() > 0;
            return bl;
        }
    }

    private void checkThread() throws SIXBSException {
        if (this.parseThread == null && this.stillParsing) {
            this.parseThread = new ParseThread(new VersionedContentHandlerWrapper(this));
            this.parseThread.setDaemon(true);
            this.parseThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.parseThread != null && this.stillParsing) {
            this.setStillParsing(false);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            try {
                this.parseThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.parseThread.isAlive()) {
                this.parseThread.stop();
            }
        }
        this.parseThread = null;
        this.setStillParsing(false);
    }

    private void setPendingException(IOException iOException) {
        this.pendingException = iOException;
    }

    private void handlePendingException() throws IOException {
        if (this.pendingException != null) {
            throw this.pendingException;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private static URL findResourceInJar(String string, String string2) throws ClassNotFoundException {
        ClassLoader classLoader = Class.forName(string).getClassLoader();
        return classLoader.getResource(string2);
    }

    static {
        DEFAULTVERSION = "1.1";
    }

    private class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            System.err.println(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            SIXBSReader.this.setPendingException(new SIXBSException(sAXParseException));
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            SIXBSReader.this.setPendingException(new SIXBSException(sAXParseException));
        }
    }

    private class ParseThread
    extends Thread {
        private XMLReader xr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ParseThread(ContentHandler contentHandler) throws SIXBSException {
            super("SIXBS ParseThread - " + contentHandler);
            try {
                if (saxParserFactory == null) {
                    saxParserFactory = SAXParserFactory.newInstance();
                    saxParserFactory.setValidating(false);
                }
                SAXParser sAXParser = null;
                SAXParserFactory sAXParserFactory = saxParserFactory;
                synchronized (sAXParserFactory) {
                    saxParserFactory.setValidating(SIXBSReader.this.getValidating());
                    sAXParser = saxParserFactory.newSAXParser();
                }
                this.xr = sAXParser.getXMLReader();
                this.xr.setContentHandler(contentHandler);
                URL uRL = SIXBSReader.findResourceInJar(this.getClass().getName(), "com/tagtraum/sixbs/sixbs1.1.dtd");
                EntityResolverImpl entityResolverImpl = new EntityResolverImpl();
                entityResolverImpl.put("-//tagtraum industries//DTD SIXBS 1.1//EN", uRL);
                this.xr.setEntityResolver((EntityResolver)entityResolverImpl);
                this.xr.setErrorHandler(new ErrorHandlerImpl());
            }
            catch (SAXException sAXException) {
                throw new SIXBSException(sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SIXBSException(parserConfigurationException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SIXBSException(classNotFoundException);
            }
        }

        public void run() {
            try {
                this.xr.parse(SIXBSReader.this.inputSource);
            }
            catch (SAXException sAXException) {
                SIXBSReader.this.setPendingException(new SIXBSException(sAXException));
            }
            catch (IOException iOException) {
                SIXBSReader.this.setPendingException(iOException);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            SIXBSReader.this.setStillParsing(false);
        }
    }
}

