/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.sixbs.test;

import com.tagtraum.sixbs.SIXBSReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SIXBSReaderTest_1_0
extends TestCase {
    public static String vcid = "$Id: SIXBSReaderTest_1_0.java,v 1.1 2001/08/05 21:50:50 Hendrik Exp $";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$com$tagtraum$sixbs$test$SIXBSReaderTest_1_0;

    public SIXBSReaderTest_1_0(String string) {
        super(string);
    }

    public void testObject() throws Exception {
        StringReader stringReader = new StringReader("<java.lang.Object id=\"0\"></java.lang.Object>");
        SIXBSReader sIXBSReader = new SIXBSReader(stringReader, "1.0");
        Object object = sIXBSReader.readObject();
        Assert.assert((String)"Make sure, simple object is read correctly.", (object != null && object.getClass() == (class$java$lang$Object == null ? (class$java$lang$Object = SIXBSReaderTest_1_0.class$("java.lang.Object")) : class$java$lang$Object) ? 1 : 0) != 0);
    }

    public void testEmptyString() throws Exception {
        StringReader stringReader = new StringReader("<java.lang.String id=\"0\"></java.lang.String>");
        SIXBSReader sIXBSReader = new SIXBSReader(stringReader, "1.0");
        Object object = sIXBSReader.readObject();
        Assert.assert((String)"Make sure, empty String is read correctly.", (object != null && object.getClass() == (class$java$lang$String == null ? (class$java$lang$String = SIXBSReaderTest_1_0.class$("java.lang.String")) : class$java$lang$String) && object.equals("") ? 1 : 0) != 0);
    }

    public void testSimpleString() throws Exception {
        StringReader stringReader = new StringReader("<java.lang.String id=\"0\">tagtraum rulez!</java.lang.String>");
        SIXBSReader sIXBSReader = new SIXBSReader(stringReader, "1.0");
        Object object = sIXBSReader.readObject();
        Assert.assert((String)"Make sure, simple String is read correctly.", (object != null && object.getClass() == (class$java$lang$String == null ? (class$java$lang$String = SIXBSReaderTest_1_0.class$("java.lang.String")) : class$java$lang$String) && object.equals("tagtraum rulez!") ? 1 : 0) != 0);
    }

    public void testBoolean() throws Exception {
        StringReader stringReader = new StringReader("<java.lang.Boolean id=\"0\">true</java.lang.Boolean>");
        SIXBSReader sIXBSReader = new SIXBSReader(stringReader, "1.0");
        Object object = sIXBSReader.readObject();
        Assert.assert((String)"Make sure, Boolean is read correctly.", (object != null && object.getClass() == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = SIXBSReaderTest_1_0.class$("java.lang.Boolean")) : class$java$lang$Boolean) && object.equals(Boolean.TRUE) ? 1 : 0) != 0);
    }

    public void testFloat() throws Exception {
        StringReader stringReader = new StringReader("<java.lang.Float id=\"0\">1.4</java.lang.Float>");
        SIXBSReader sIXBSReader = new SIXBSReader(stringReader, "1.0");
        Object object = sIXBSReader.readObject();
        Assert.assert((String)"Make sure, Float is read correctly.", (object != null && object.getClass() == (class$java$lang$Float == null ? (class$java$lang$Float = SIXBSReaderTest_1_0.class$("java.lang.Float")) : class$java$lang$Float) && object.equals(new Float(1.4)) ? 1 : 0) != 0);
    }

    public void testNull() throws Exception {
        StringReader stringReader = new StringReader("<com.tagtraum.sixbs.Null id=\"0\"></com.tagtraum.sixbs.Null>");
        SIXBSReader sIXBSReader = new SIXBSReader(stringReader, "1.0");
        Object object = sIXBSReader.readObject();
        Assert.assert((String)"Make sure, Null is read correctly.", (object == null ? 1 : 0) != 0);
    }

    public void testEntityReference() throws Exception {
        StringReader stringReader = new StringReader("<java.lang.String id=\"0\">&lt;&#50;</java.lang.String>");
        SIXBSReader sIXBSReader = new SIXBSReader(stringReader, "1.0");
        Object object = sIXBSReader.readObject();
        Assert.assert((String)"Make sure, EntityReferences are read correctly.", (boolean)object.equals("<2"));
    }

    public void testURL() throws IOException {
        StringReader stringReader = new StringReader("<java.net.URL id=\"0\">http://www.tagtraum.com:8080/resource?hello=you</java.net.URL>");
        SIXBSReader sIXBSReader = new SIXBSReader(stringReader, "1.0");
        Object object = sIXBSReader.readObject();
        Assert.assert((String)"Failed to read URL correctly.", (boolean)object.equals(new URL("http://www.tagtraum.com:8080/resource?hello=you")));
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$tagtraum$sixbs$test$SIXBSReaderTest_1_0 == null ? (class$com$tagtraum$sixbs$test$SIXBSReaderTest_1_0 = SIXBSReaderTest_1_0.class$("com.tagtraum.sixbs.test.SIXBSReaderTest_1_0")) : class$com$tagtraum$sixbs$test$SIXBSReaderTest_1_0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SIXBSReaderTest_1_0.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

