/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.sixbs.test;

import com.tagtraum.sixbs.AdapterFinder;
import com.tagtraum.sixbs.SIXBSWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SIXBSWriterTest_1_0
extends TestCase {
    public static String vcid = "$Id: SIXBSWriterTest_1_0.java,v 1.1 2001/08/05 21:50:50 Hendrik Exp $";
    private CharArrayWriter out;
    private SIXBSWriter writer;
    static /* synthetic */ Class class$com$tagtraum$sixbs$test$SIXBSWriterTest_1_0;

    public SIXBSWriterTest_1_0(String string) {
        super(string);
    }

    public void setUp() throws IOException {
        this.out = new CharArrayWriter();
        this.writer = new SIXBSWriter(this.out, AdapterFinder.getDefaultAdapterFinder(), true, null, "1.0");
    }

    public void tearDown() {
        this.out = null;
        this.writer = null;
    }

    public void testObject() throws IOException {
        Object object = new Object();
        this.writer.writeObject(object);
        Assert.assert((String)"Make sure, simple object is written correctly.", (boolean)this.out.toString().equals("<java.lang.Object id=\"0\"></java.lang.Object>"));
    }

    public void testEmptyString() throws IOException {
        String string = new String();
        this.writer.writeObject(string);
        Assert.assert((String)"Make sure, empty String is written correctly.", (boolean)this.out.toString().equals("<java.lang.String id=\"0\"></java.lang.String>"));
    }

    public void testSimpleString() throws IOException {
        String string = new String("tagtraum rulez!");
        this.writer.writeObject(string);
        Assert.assert((String)"Make sure, simple String is written correctly.", (boolean)this.out.toString().equals("<java.lang.String id=\"0\">tagtraum rulez!</java.lang.String>"));
    }

    public void testBoolean() throws IOException {
        Boolean bl = new Boolean(true);
        this.writer.writeObject(bl);
        Assert.assert((String)"Make sure, Boolean is written correctly.", (boolean)this.out.toString().equals("<java.lang.Boolean id=\"0\">true</java.lang.Boolean>"));
    }

    public void testFloat() throws IOException {
        Float f = new Float(1.4);
        this.writer.writeObject(f);
        Assert.assert((String)"Make sure, Float is written correctly.", (boolean)this.out.toString().equals("<java.lang.Float id=\"0\">1.4</java.lang.Float>"));
    }

    public void testNull() throws IOException {
        this.writer.writeObject(null);
        Assert.assert((String)"Make sure, Null is written correctly.", (boolean)this.out.toString().equals("<com.tagtraum.sixbs.Null id=\"0\"></com.tagtraum.sixbs.Null>"));
    }

    public void testURL() throws IOException {
        this.writer.writeObject(new URL("http://www.tagtraum.com:8080/resource?hello=you"));
        Assert.assert((String)"Failed to write URL correctly.", (boolean)this.out.toString().equals("<java.net.URL id=\"0\">http://www.tagtraum.com:8080/resource?hello=you</java.net.URL>"));
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$tagtraum$sixbs$test$SIXBSWriterTest_1_0 == null ? (class$com$tagtraum$sixbs$test$SIXBSWriterTest_1_0 = SIXBSWriterTest_1_0.class$("com.tagtraum.sixbs.test.SIXBSWriterTest_1_0")) : class$com$tagtraum$sixbs$test$SIXBSWriterTest_1_0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SIXBSWriterTest_1_0.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

