/*
License $Id: EntityResolverImpl.java,v 1.3 2001/10/28 12:25:49 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

LGPL
====

jo! is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

jo! is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>


Sun license
===========

This release contains software by Sun Microsystems. Therefore
the following conditions have to be met, too. They apply to the
files

 - lib/mail.jar
 - lib/activation.jar
 - lib/jsse.jar
 - lib/jcert.jar
 - lib/jaxp.jar
 - lib/crimson.jar
 - lib/servlet.jar
 - lib/jnet.jar
 - lib/jaas.jar
 - lib/jaasmod.jar

contained in this release.

a. Licensee may not modify the Java Platform
   Interface (JPI, identified as classes contained within the javax
   package or any subpackages of the javax package), by creating additional
   classes within the JPI or otherwise causing the addition to or modification
   of the classes in the JPI.  In the event that Licensee creates any
   Java-related API and distribute such API to others for applet or
   application development, you must promptly publish broadly, an accurate
   specification for such API for free use by all developers of Java-based
   software.

b. Software is confidential copyrighted information of Sun and
   title to all copies is retained by Sun and/or its licensors.  Licensee
   shall not modify, decompile, disassemble, decrypt, extract, or otherwise
   reverse engineer Software.  Software may not be leased, assigned, or
   sublicensed, in whole or in part.  Software is not designed or intended
   for use in on-line control of aircraft, air traffic, aircraft navigation
   or aircraft communications; or in the design, construction, operation or
   maintenance of any nuclear facility.  Licensee warrants that it will not
   use or redistribute the Software for such purposes.

c. Software is provided "AS IS," without a warranty
   of any kind. ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES,
   INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
   PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.

d. This License is effective until terminated.  Licensee may
   terminate this License at any time by destroying all copies of Software.
   This License will terminate immediately without notice from Sun if Licensee
   fails to comply with any provision of this License.  Upon such termination,
   Licensee must destroy all copies of Software.

e. Software, including technical data, is subject to U.S.
   export control laws, including the U.S.  Export Administration Act and its
   associated regulations, and may be subject to export or import regulations
   in other countries.  Licensee agrees to comply strictly with all such
   regulations and acknowledges that it has the responsibility to obtain
   licenses to export, re-export, or import Software.  Software may not be
   downloaded, or otherwise exported or re-exported (i) into, or to a national
   or resident of, Cuba, Iraq, Iran, North Korea, Libya, Sudan, Syria or any
   country to which the U.S. has embargoed goods; or (ii) to anyone on the
   U.S. Treasury Department's list of Specially Designated Nations or the U.S.
   Commerce Department's Table of Denial Orders.


Feedback
========

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
<feedback@tagtraum.com>

For more information on tagtraum industries and jo!
please see <http://www.tagtraum.com/>.


*/
package com.tagtraum.framework.util;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;


/**
 * Resolves Entities.
 *
 * @author <a href="mailto:hs@tagtraum.com">Hendrik Schreiber</a>, <a href="mailto:jules_gosnell@yahoo.com">Julian Gosnell</a>
 * @version $Id: EntityResolverImpl.java,v 1.3 2001/10/28 12:25:49 Hendrik Exp $
 */
public class EntityResolverImpl implements EntityResolver {

    /**
     * Source-Version
     */
    public static String vcid = "$Id: EntityResolverImpl.java,v 1.3 2001/10/28 12:25:49 Hendrik Exp $";

    private Hashtable table = new Hashtable();

    /**
     * Returns an InputSource for a publicId.
     *
     * @return InputSource or null, if not resolvable
     */
    public InputSource resolveEntity(String publicId, String systemId) {
        URL url = (URL)table.get(publicId);
        if (url != null) {
            try {
                return new InputSource(url.openConnection().getInputStream());
            }
            catch (IOException ioe) {
                new RuntimeException(ioe.toString());
            }
        }
        return null;
    }

    /**
     * Register publicId/URL pair.
     */
    public void put(String key, URL val) {
        table.put(key, val);
    }
}
