/*

License $Id: AbstractAdapter.java,v 1.2 2001/08/06 16:46:41 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;

/**
 * Convenience superclass for {@link Adapter}s.
 * 
 * @author 	<a href="mailto:hs@tagtraum.com">Hendrik Schreiber</a>
 * @version $Id: AbstractAdapter.java,v 1.2 2001/08/06 16:46:41 Hendrik Exp $
 */
abstract public class AbstractAdapter implements Adapter {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: AbstractAdapter.java,v 1.2 2001/08/06 16:46:41 Hendrik Exp $";

    /**
     * Returns the object that has been initialized from XML by calling the
     * setter methods of a class implementing this interface.<p>
     * Example:<p>
     * In {@link com.tagtraum.sixbs.adapters.util.ArrayListAdapt} this method
     * returns an initialized {@link java.util.ArrayList}. The ArrayList
     * has been initialized by the Adapter, when the
     * {@link com.tagtraum.sixbs.adapters.util.ListAdapt#setList(Object[])}
     * method was called by {@link SIXBSReader}.
     */
    abstract public Object deserialize() throws SIXBSException;
    
    public boolean equals(Object obj) {
        try {
            return (obj instanceof Adapter) && (deserialize() == ((Adapter)obj).deserialize());
        }
        catch (SIXBSException sixbse) {
            sixbse.printStackTrace();
            throw new RuntimeException(sixbse.toString());
        }
    }
    
    public int hashCode() {
        // this is much like a hack and should be cleaner (rik)
        try {
            return deserialize().hashCode();
        }
        catch (SIXBSException sixbse) {
            sixbse.printStackTrace();
            throw new RuntimeException(sixbse.toString());
        }
    }

    
}
