/*

License $Id: Adapter.java,v 1.2 2001/08/06 16:46:42 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;


/**
 * If you want to serialize objects that do not comply to the java beans
 * conventions or objects that were provided by a third party, you should
 * write an Adapter.<p>
 * Adapters are classes that hold the object you want to serialize. They
 * expose properties through methods, that are easily serializable by SIXBS. I.e.
 * they form an adapter between the actual object and the format SIXBS can process.<p>
 * If you are serializing an object that has an adapter, the adapter is instantiated
 * and then the Adapter is written, not the object. When you read a serialized Adapter, it
 * instantiates the original object, sets all necessary properties and returns
 * the object, not the adapter.<p>
 * A class implementing this interface must have a no-argument constructor and a one argument
 * constructor. The argument must be of the type the adapter is adapting to.
 * The adapter class must be named <code>[classname]Adapt</code> and has to be located
 * in the adapter searchpath (see {@link AdapterFinder}).<p>
 * SIXBS will use the get and set methods of the adapter to (de)serialize
 * the bean. Beans using this mechanism must have a no argument constructor.
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: Adapter.java,v 1.2 2001/08/06 16:46:42 Hendrik Exp $
 * @see AdapterFinder
 */
public interface Adapter {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: Adapter.java,v 1.2 2001/08/06 16:46:42 Hendrik Exp $";
    
    /**
     * Returns the object that has been initialized from XML by calling the
     * setter methods of a class implementing this interface.<p>
     * Example:<p>
     * In {@link com.tagtraum.sixbs.adapters.util.ArrayListAdapt} this method
     * returns an initialized {@link java.util.ArrayList}. The ArrayList
     * has been initialized by the Adapter, when the
     * {@link com.tagtraum.sixbs.adapters.util.ListAdapt#setList(Object[])}
     * method was called by {@link SIXBSReader}.
     */
    public Object deserialize() throws SIXBSException;
}
