/*

License $Id: ContentHandlerImpl_1_1.java,v 1.1 2001/08/06 16:46:42 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;

import java.util.*;
import java.io.*;
import java.lang.reflect.*;
import java.net.URL;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import com.tagtraum.framework.util.*;

/**
 * Is notified by the parser and build the objects from the notifications.
 * <p>Uses SAX2, therefore part of the documentation
 * is from the SAX2 docs.
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: ContentHandlerImpl_1_1.java,v 1.1 2001/08/06 16:46:42 Hendrik Exp $
 */
class ContentHandlerImpl_1_1 extends AbstractContentHandlerImpl {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: ContentHandlerImpl_1_1.java,v 1.1 2001/08/06 16:46:42 Hendrik Exp $";

    public ContentHandlerImpl_1_1(SIXBSReader reader) {
        super(reader);
    }

    /**
     * Receive notification of the beginning of an element.
     *
     * <p>The Parser will invoke this method at the beginning of every
     * element in the XML document; there will be a corresponding
     * {@link #endElement endElement} event for every startElement event
     * (even when the element is empty). All of the element's content will be
     * reported, in order, before the corresponding endElement
     * event.</p>
     *
     * <p>This event allows up to three name components for each
     * element:</p>
     *
     * <ol>
     * <li>the Namespace URI;</li>
     * <li>the local name; and</li>
     * <li>the qualified (prefixed) name.</li>
     * </ol>
     *
     * <p>Any or all of these may be provided, depending on the
     * values of the <var>http://xml.org/sax/features/namespaces</var>
     * and the <var>http://xml.org/sax/features/namespace-prefixes</var>
     * properties:</p>
     *
     * <ul>
     * <li>the Namespace URI and local name are required when 
     * the namespaces property is <var>true</var> (the default), and are
     * optional when the namespaces property is <var>false</var> (if one is
     * specified, both must be);</li>
     * <li>the qualified name is required when the namespace-prefixes property
     * is <var>true</var>, and is optional when the namespace-prefixes property
     * is <var>false</var> (the default).</li>
     * </ul>
     *
     * <p>Note that the attribute list provided will contain only
     * attributes with explicit values (specified or defaulted):
     * #IMPLIED attributes will be omitted.  The attribute list
     * will contain attributes used for Namespace declarations
     * (xmlns* attributes) only if the
     * <code>http://xml.org/sax/features/namespace-prefixes</code>
     * property is true (it is false by default, and support for a 
     * true value is optional).</p>
     *
     * @param uri The Namespace URI, or the empty string if the
     *        element has no Namespace URI or if Namespace
     *        processing is not being performed.
     * @param localName The local name (without prefix), or the
     *        empty string if Namespace processing is not being
     *        performed.
     * @param qName The qualified name (with prefix), or the
     *        empty string if qualified names are not available.
     * @param atts The attributes attached to the element.  If
     *        there are no attributes, it shall be an empty
     *        Attributes object.
     * @exception org.xml.sax.SAXException Any SAX exception, possibly
     *            wrapping another exception.
     * @see #endElement
     * @see Attributes
     */
    public void startElement (String namespaceURI, String localName,
                  String qName, Attributes atts) throws SAXException {

        State state = null;
        try {
            if (!empty()) state = peek();
            if (localName.equals("object")) {
                String id = atts.getValue("id");
                if (id == null || id.equals("")) throw new SAXException(localStrings.getString("attribute_id_missing"));
                String classname = atts.getValue("class");
                if (classname == null || classname.equals("")) throw new SAXException(localStrings.getString("attribute_class_missing"));
                if (classname.equals(NULL.getClass().getName())) {
                    push(new State(OBJECT, NULL));
                }
                else {
                    Class klass = Class.forName(classname);
                    if ((klass != Object.class)
                        && (klass == String.class
                        || klass.getSuperclass() == Number.class
                        || klass == Character.class
                        || klass == Boolean.class
                        || klass == URL.class)) {
                            push(new State(LITERAL, klass.getConstructor(STRING_OBJECT)));
                    }
                    else {
                        Object object = klass.newInstance();
                        push(new State(OBJECT, object, id));
                    }
                }
            }
            else if (localName.equals("reference")) {
                String id = atts.getValue("id");
                if (id == null || id.equals("")) throw new SAXException(localStrings.getString("attribute_id_missing"));
                push(new State(OBJECT, objectIdentifier.getObject(id), id));
            }
            else if (localName.equals("array")) {
                String type = atts.getValue("type");
                //boolean array = "true".equals(atts.getValue("array"));
                if (type == null || type.equals("")) throw new SAXException(localStrings.getString("attribute_type_missing"));
                String id = atts.getValue("id");
                if (id == null || id.equals("")) throw new SAXException(localStrings.getString("attribute_id_missing"));
                push(new State(ARRAY, new TypedArray(type), id));
            }
            else if (localName.equals("property")) {
                String name = atts.getValue("name");
                if (name == null || name.equals("")) throw new SAXException(localStrings.getString("attribute_name_missing"));
                push(new State(PROPERTY, ReflectHelper.getWriteMethods(peek().getContext().getClass()).get(name)));
            }
            else if (localName.equals(SIXBS)) {
                String version = atts.getValue("version");
                if (version == null || version.equals("")) throw new SAXException(localStrings.getString("attribute_version_missing"));
                if (!version.equals("1.1")) throw new SAXException(localStrings.getString("wrong_version_1_1") + version);
            }
            else throw new SAXException(localStrings.getString("unknown_tag") + localName);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new SAXException(localStrings.getString("class_not_found") + " " + cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new SAXException(localStrings.getString("constructor_not_found") + " " + nsme);
        }
        catch (InstantiationException ie) {
            throw new SAXException(localStrings.getString("instantiation_failed") + " " + ie);
        }
        catch (IllegalAccessException iae) {
            throw new SAXException(localStrings.getString("class_instantiation_forbidden") + " " + iae);
        }
        catch (RuntimeException rte) {
            rte.printStackTrace();
            throw new SAXException(rte);
        }
    }
}