/*

License $Id: ObjectIdentifier.java,v 1.3 2001/08/05 21:50:49 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;

import java.util.*;

/**
 * Provides unique IDs for Objects.
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: ObjectIdentifier.java,v 1.3 2001/08/05 21:50:49 Hendrik Exp $
 */
class ObjectIdentifier {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: ObjectIdentifier.java,v 1.3 2001/08/05 21:50:49 Hendrik Exp $";

    private HashMap objects;
    private HashMap ids;
    
    public ObjectIdentifier() {
        objects = new HashMap();
        ids = new HashMap();
    }    
    
    /**
     * Tests whether a object is already registered and returns its id.
     */
    public String getId(Object obj) {
        ObjectIdentityWrapper key = new ObjectIdentityWrapper(obj);
        return (String)ids.get(key);
    }

    /**
     * Returns an Object for an id.
     */
    public Object getObject(String id) {
        return objects.get(id);
    }
    
    /**
     * Registers an object while de-serialization.
     */
    public void registerObject(String id, Object object) {
        objects.put(id, object);
    }
    
    /**
     * Returns the ID for an object. If none exists, a new one is created.
     * ids are hex coded.
     */
    public String createId(Object obj) {
        ObjectIdentityWrapper key = new ObjectIdentityWrapper(obj);
        String id = (String)ids.get(key);
        if (id == null) {
            id = Integer.toString(objects.size(), 16);
            ids.put(key, id);
            objects.put(id, obj);
        }
        return id;
    }
}

class ObjectIdentityWrapper {
    private Object obj;
    ObjectIdentityWrapper(Object obj) {
        this.obj = obj;
    }
    public boolean equals(Object oiw) {
        return (oiw instanceof ObjectIdentityWrapper) && (this.obj == ((ObjectIdentityWrapper)oiw).obj);
    }
    public int hashCode() {
        return obj == null?0:obj.hashCode();
    }
}