/*

License $Id: SIXBSException.java,v 1.1 2001/05/06 14:55:01 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;

import java.io.*;

/**
 * SIXBS Exception.
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: SIXBSException.java,v 1.1 2001/05/06 14:55:01 Hendrik Exp $
 */
public class SIXBSException extends IOException {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: SIXBSException.java,v 1.1 2001/05/06 14:55:01 Hendrik Exp $";
    
    private Throwable nested;

    public SIXBSException(String message, Throwable t) {
        super(message);
        nested = t;
    }

    public SIXBSException(Throwable t) {
        this("SIXBSException", t);
    }
    
    public Throwable getNestedThrowable() {
        return nested;
    }
    
    
    public String toString() {
        return nested == null ?
            super.toString() : super.toString() + " " + nested.toString();
    }
}
