/*

License $Id: SIXBSSerializable.java,v 1.3 2001/08/06 16:46:42 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;

/**
 * Marks an object as SIXBS-serializable, with special rules. This means that
 * properties are only serialized, if the method {@link #serializable(String)} with the
 * property name as argument returns true.<p>
 * This interface should be used, when you are writing new code, that
 * explicitly wants to use SIXBS, but has public properties that should
 * not be serialized. Think of this as a way to mark properties as <i>transient</i>.
 * <p>
 * If you want to serialize objects that do not comply with the java beans conventions,
 * which have been written by a third party, you have to create an {@link Adapter}.
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: SIXBSSerializable.java,v 1.3 2001/08/06 16:46:42 Hendrik Exp $
 * @see Adapter
 */
public interface SIXBSSerializable {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: SIXBSSerializable.java,v 1.3 2001/08/06 16:46:42 Hendrik Exp $";


    /**
     * Indicates whether a certain property should be serialized or not.
     *
     * @param propertyname Name of the property. E.g. <code>name</code> if the
     *     methods <code>setName()</code> and <code>getName()</code> exist
     * @return true, if the property shall be serialized
     */
    public boolean serializable(String propertyname);
}