/*

License $Id: SIXBSWriterImpl_1_0.java,v 1.2 2001/08/06 16:46:42 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;

import org.w3c.dom.*;
import java.util.*;
import java.io.*;
import java.net.URL;
import java.lang.reflect.*;
import com.tagtraum.framework.util.*;

/**
 * Serializes beans to XML.
 *
 * @author 	Hendrik Schreiber
 * @version $Id: SIXBSWriterImpl_1_0.java,v 1.2 2001/08/06 16:46:42 Hendrik Exp $
 */
class SIXBSWriterImpl_1_0 extends AbstractSIXBSWriterImpl {

    /**
     * Source-Version
     */
    public static String	vcid =
	"$Id: SIXBSWriterImpl_1_0.java,v 1.2 2001/08/06 16:46:42 Hendrik Exp $";

    /**
     * For performance reasons the Writer should be buffered. sixbs does <i>not</i>
     * buffer. sixbs will write with the systems default encoding or the encoding
     * set in the provided buffer.
     *
     * @param out Writer to write objects to with the specified encoding.
     * @param append if true, no XML declaration (&lt;?xml version="1.0"?&gt;)is written.
     * @param adapterFinder the adapterFinder to use
     * @param encoding encoding that is used by the writer - set null, if unknwon
     */
    public SIXBSWriterImpl_1_0(Writer out, AdapterFinder adapterFinder, boolean append, String encoding) throws IOException {
        super(out, adapterFinder, append, encoding);
    }

    public void writePlainObject(Object obj, String id) throws IOException {
        out.write("<");
        writeClass(obj);
        out.write(" id=\"");
        out.write(id);
        out.write("\">");
        Class klass = obj.getClass();
        if ((klass != Object.class)
            && (klass == String.class
            || klass.getSuperclass() == Number.class
            || klass == Character.class
            || klass == Boolean.class
            || klass == URL.class)) {
                out.write(encode(obj.toString()));
        } else {
            writeProperties(obj);
        }
        out.write("</");
        writeClass(obj);
        out.write(">");
    }

    public void writeReference(String id) throws IOException {
        out.write("<");
        out.write(REFERENCE);
        out.write(" id=\"");
        out.write(id);
        out.write("\"/>");
    }

    public void writeArray(Object obj, String id) throws IOException {
        out.write("<");
        out.write(TypedArray.class.getName());
        out.write(" type=\"");
        //if (obj.getClass().getComponentType().isArray()) {
        out.write(obj.getClass().getComponentType().getName());
        /*
        out.write("\" array=\"");
        out.write(obj.getClass().getComponentType().isArray()?"true":"false");
        */
        out.write("\" id=\"");
        out.write(id);
        out.write("\">");
        if (obj.getClass().getComponentType().isPrimitive()) {
            for (int j=0; j<Array.getLength(obj); j++) {
                writeObject(Array.get(obj, j));
            }
        }
        else {
            Object[] array = (Object[])obj;
            for (int j=0; j<array.length; j++) {
                writeObject(array[j]);
            }
        }
        out.write("</");
        out.write(TypedArray.class.getName());
        out.write(">");
    }

    private void writeProperties(Object obj) throws IOException {
        // Class Object has no properties.
        if (obj.getClass() == Object.class) return;
        try {
            HashMap readMethodMap = ReflectHelper.getReadMethods(obj.getClass());
            HashMap writeMethodMap = ReflectHelper.getWriteMethods(obj.getClass());
            Iterator readMethods = readMethodMap.keySet().iterator();
            while (readMethods.hasNext()) {
                String name = (String)readMethods.next();
                // write only if when can set the value, too (rik)
                if (writeMethodMap.containsKey(name) && writeProperty(obj, name)) {
                    Method readMethod = (Method)readMethodMap.get(name);
                    Object property = readMethod.invoke(obj, NOARGS);
                    if (property == null) property = NULL;
                    out.write("<");
                    out.write(name);
                    out.write(">");
                    writeObject(property);
                    out.write("</");
                    out.write(name);
                    out.write(">");
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (IllegalAccessException iae) {
            throw new SIXBSException(localStrings.getString("property_read_invocation_failed"), iae);
        }
        catch (InvocationTargetException ite) {
            throw new SIXBSException(localStrings.getString("property_read_invocation_failed"), ite.getTargetException());
        }
    }

    /**
     * Returns the version of this WriterHandler: "1.0".
     */
    public String getVersion() {
        return "1.0";
    }
}