/*

License $Id: State.java,v 1.3 2001/08/06 16:46:42 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;


/**
 * Represents a state and its context. This could be extended to contain
 * the full logic.
 *
 * @author 	Hendrik Schreiber
 * @version $Id: State.java,v 1.3 2001/08/06 16:46:42 Hendrik Exp $
 */
class State {

    /**
     * Source-Version
     */
    public static String	vcid =
	"$Id: State.java,v 1.3 2001/08/06 16:46:42 Hendrik Exp $";

    private int state;
    private Object context;
    private String id;

    public State(int state, Object context, String id) {
        this.state = state;
        this.context = context;
        this.id = id;
    }

    public State(int state, Object context) {
        this(state, context, null);
    }

    public State(int state) {
        this(state, null, null);
    }

    public int getState() {
        return state;
    }

    public Object getContext() {
        return context;
    }

    public String getId() {
        return id;
    }

    public void set(int state, Object context) {
        this.state = state;
        this.context = context;
    }

    public String toString() {
        return "State: " + state + " - " + context;
    }
}
