/*

License $Id: VersionedContentHandlerWrapper.java,v 1.1 2001/08/05 21:50:49 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs;

import java.util.*;
import java.io.*;
import java.lang.reflect.*;
import java.net.URL;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import com.tagtraum.framework.util.*;

/**
 * Will instantiate the ContentHandlerImpl with the right version
 * and wrap around it.
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: VersionedContentHandlerWrapper.java,v 1.1 2001/08/05 21:50:49 Hendrik Exp $
 */
class VersionedContentHandlerWrapper implements ContentHandler {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: VersionedContentHandlerWrapper.java,v 1.1 2001/08/05 21:50:49 Hendrik Exp $";

    private static final String SIXBS = "sixbs";
    private static final String VERSION = "version";
    private static ResourceBundle localStrings = ResourceBundle.getBundle("com.tagtraum.sixbs.localStrings");

    private ContentHandler contentHandler;
    private SIXBSReader reader;

    public VersionedContentHandlerWrapper(SIXBSReader reader) {
        this.reader = reader;
    }

    public void startDocument() throws SAXException {
        if (contentHandler != null) contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        if (contentHandler != null) contentHandler.endDocument();
    }

    public void startPrefixMapping(String s, String s1) throws SAXException {
        if (contentHandler != null) contentHandler.startPrefixMapping(s, s1);
    }

    public void endPrefixMapping(String s) throws SAXException {
        if (contentHandler != null) contentHandler.endPrefixMapping(s);
    }

    public void startElement (String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (contentHandler == null) {
            try {
                if (localName.equals(SIXBS)) {
                    newContentHandler(atts.getValue(VERSION));
                }
                else {
                    newContentHandler(reader.getDefaultVersion());
                    contentHandler.startElement(namespaceURI, localName, qName, atts);
                }
            }
            catch (SIXBSException e) {
                throw new SAXException(e.toString());
            }
        }
        else {
            contentHandler.startElement(namespaceURI, localName, qName, atts);
        }
    }

    private void newContentHandler(String version) throws SIXBSException {
        String realVersion = version.replace('.', '_');
        try {
            Class handlerClass = Class.forName("com.tagtraum.sixbs.ContentHandlerImpl_" + realVersion);
            contentHandler = (ContentHandler)handlerClass.getConstructor(new Class[] {SIXBSReader.class}).newInstance(new Object[] {reader});
            reader.setVersion(realVersion);
        }
        catch (Exception e) {
            throw new SIXBSException(localStrings.getString("contenthandlerimpl_instantiation_failed") + realVersion, e);
        }
    }

    public void endElement(String s, String s1, String s2) throws SAXException {
        if (contentHandler != null) contentHandler.endElement(s, s1, s2);
    }

    public void characters(char[] chars, int i, int i1) throws SAXException {
        if (contentHandler != null) contentHandler.characters(chars, i, i1);
    }

    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
        if (contentHandler != null) contentHandler.ignorableWhitespace(chars, i, i1);
    }

    public void processingInstruction(String s, String s1) throws SAXException {
        if (contentHandler != null) contentHandler.processingInstruction(s, s1);
    }

    public void skippedEntity(String s) throws SAXException {
        if (contentHandler != null) contentHandler.skippedEntity(s);
    }

    public void setDocumentLocator(Locator locator) {
        if (contentHandler != null) contentHandler.setDocumentLocator(locator);
    }
}