/*

License $Id: ListAdaptTest.java,v 1.3 2001/08/06 16:46:43 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs.adapters.util.test;

import com.tagtraum.sixbs.*;
import com.tagtraum.sixbs.adapters.util.*;
import junit.framework.*;
import java.io.*;
import java.util.*;

/**
 * 
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: ListAdaptTest.java,v 1.3 2001/08/06 16:46:43 Hendrik Exp $
 */
public class ListAdaptTest extends TestCase {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: ListAdaptTest.java,v 1.3 2001/08/06 16:46:43 Hendrik Exp $";

    public ListAdaptTest(String name) {
        super(name);
    }
    
    public void testWriteArrayList() throws IOException {
        CharArrayWriter out = new CharArrayWriter();
        SIXBSWriter writer = new SIXBSWriter(out, AdapterFinder.getDefaultAdapterFinder(), true, null, "1.0");
        ArrayList list = new ArrayList();
        list.add("aString");
        writer.writeObject(list);
        //System.out.println(out.toString());
        assert("The arraylist was not written correctly.", out.toString().equals("<com.tagtraum.sixbs.adapters.util.ArrayListAdapt id=\"0\"><list><com.tagtraum.sixbs.TypedArray type=\"java.lang.Object\" id=\"1\"><java.lang.String id=\"2\">aString</java.lang.String></com.tagtraum.sixbs.TypedArray></list></com.tagtraum.sixbs.adapters.util.ArrayListAdapt>"));
    }

    public void testWriteAndReadArrayList() throws IOException {
        CharArrayWriter out = new CharArrayWriter();
        SIXBSWriter writer = new SIXBSWriter(out, false);
        ArrayList list = new ArrayList();
        list.add("1");
        list.add("2");
        list.add(new Integer(3));
        writer.writeObject(list);
        writer.close();
        Reader in = new StringReader(out.toString());
        SIXBSReader reader = new SIXBSReader(in);
        Object readObject = reader.readObject();
        //System.out.println(out.toString());
        assert("ArrayList wasn't serialized and deserialized correctly.", readObject.equals(list));
    }


    public static TestSuite suite() {
        return new TestSuite(ListAdaptTest.class);
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
}