/*

License $Id: MapAdaptTest.java,v 1.3 2001/08/06 16:46:43 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs.adapters.util.test;

import com.tagtraum.sixbs.*;
import com.tagtraum.sixbs.adapters.util.*;
import junit.framework.*;
import java.io.*;
import java.util.*;

/**
 * 
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: MapAdaptTest.java,v 1.3 2001/08/06 16:46:43 Hendrik Exp $
 */
public class MapAdaptTest extends TestCase {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: MapAdaptTest.java,v 1.3 2001/08/06 16:46:43 Hendrik Exp $";
        
    public MapAdaptTest(String name) {
        super(name);
    }
    
    public void testWriteMap() throws IOException {
        CharArrayWriter out = new CharArrayWriter();
        SIXBSWriter writer = new SIXBSWriter(out, AdapterFinder.getDefaultAdapterFinder(), true, null, "1.0");
        HashMap map = new HashMap();
        map.put("aKey", "aValue");
        map.put("anotherKey", "anotherValue");
        writer.writeObject(map);
        //System.out.println(out.toString());
        assert("Make sure, a HashMap is written correctly.", out.toString().equals("<com.tagtraum.sixbs.adapters.util.HashMapAdapt id=\"0\"><mapEntries><com.tagtraum.sixbs.TypedArray type=\"com.tagtraum.sixbs.adapters.util.MapEntry\" id=\"1\"><com.tagtraum.sixbs.adapters.util.MapEntry id=\"2\"><key><java.lang.String id=\"3\">anotherKey</java.lang.String></key><value><java.lang.String id=\"4\">anotherValue</java.lang.String></value></com.tagtraum.sixbs.adapters.util.MapEntry><com.tagtraum.sixbs.adapters.util.MapEntry id=\"5\"><key><java.lang.String id=\"6\">aKey</java.lang.String></key><value><java.lang.String id=\"7\">aValue</java.lang.String></value></com.tagtraum.sixbs.adapters.util.MapEntry></com.tagtraum.sixbs.TypedArray></mapEntries></com.tagtraum.sixbs.adapters.util.HashMapAdapt>"));
    }

    public void testWriteAndReadMap() throws IOException {
        CharArrayWriter out = new CharArrayWriter();
        SIXBSWriter writer = new SIXBSWriter(out, false);
        HashMap map = new HashMap();
        map.put("aKey", "aValue");
        map.put("anotherKey", "anotherValue");
        writer.writeObject(map);
        writer.close();
        Reader in = new StringReader(out.toString());
        SIXBSReader reader = new SIXBSReader(in);
        Object readObject = reader.readObject();
        //System.out.println(out.toString());
        assert("Map wasn't serialized and deserialized correctly.", readObject.equals(map));
    }

    public static TestSuite suite() {
        return new TestSuite(MapAdaptTest.class);
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
}