/*

License $Id: SIXBSReaderTest_1_0.java,v 1.1 2001/08/05 21:50:50 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs.test;

import com.tagtraum.sixbs.*;
import junit.framework.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 *
 *
 * @author 	Hendrik Schreiber
 * @version $Id: SIXBSReaderTest_1_0.java,v 1.1 2001/08/05 21:50:50 Hendrik Exp $
 */
public class SIXBSReaderTest_1_0 extends TestCase {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: SIXBSReaderTest_1_0.java,v 1.1 2001/08/05 21:50:50 Hendrik Exp $";
    
    
    public SIXBSReaderTest_1_0(String name) {
        super(name);
    }
    
    
    public void testObject() throws Exception {
        StringReader in = new StringReader("<java.lang.Object id=\"0\"></java.lang.Object>");
        SIXBSReader reader = new SIXBSReader(in, "1.0");
        Object obj = reader.readObject();
        assert("Make sure, simple object is read correctly.", obj!=null && obj.getClass() == Object.class);
    }
    
    public void testEmptyString() throws Exception {
        StringReader in = new StringReader("<java.lang.String id=\"0\"></java.lang.String>");
        SIXBSReader reader = new SIXBSReader(in, "1.0");
        Object obj = reader.readObject();
        assert("Make sure, empty String is read correctly.", obj!=null && obj.getClass() == String.class && obj.equals(""));
    }

    public void testSimpleString() throws Exception {
        StringReader in = new StringReader("<java.lang.String id=\"0\">tagtraum rulez!</java.lang.String>");
        SIXBSReader reader = new SIXBSReader(in, "1.0");
        Object obj = reader.readObject();
        assert("Make sure, simple String is read correctly.", obj!=null && obj.getClass() == String.class && obj.equals("tagtraum rulez!"));
    }

    public void testBoolean() throws Exception {
        StringReader in = new StringReader("<java.lang.Boolean id=\"0\">true</java.lang.Boolean>");
        SIXBSReader reader = new SIXBSReader(in, "1.0");
        Object obj = reader.readObject();
        assert("Make sure, Boolean is read correctly.", obj!=null && obj.getClass() == Boolean.class && obj.equals(Boolean.TRUE));
    }

    public void testFloat() throws Exception {
        StringReader in = new StringReader("<java.lang.Float id=\"0\">1.4</java.lang.Float>");
        SIXBSReader reader = new SIXBSReader(in, "1.0");
        Object obj = reader.readObject();
        assert("Make sure, Float is read correctly.", obj!=null && obj.getClass() == Float.class && obj.equals(new Float(1.4)));
    }

    public void testNull() throws Exception {
        StringReader in = new StringReader("<com.tagtraum.sixbs.Null id=\"0\"></com.tagtraum.sixbs.Null>");
        SIXBSReader reader = new SIXBSReader(in, "1.0");
        Object obj = reader.readObject();
        //System.out.println("null == " + obj);
        assert("Make sure, Null is read correctly.", obj==null);
    }

    public void testEntityReference() throws Exception {
        StringReader in = new StringReader("<java.lang.String id=\"0\">&lt;&#50;</java.lang.String>");
        SIXBSReader reader = new SIXBSReader(in, "1.0");
        Object obj = reader.readObject();
        //System.out.println("'<2' == '" + obj + "'");
        assert("Make sure, EntityReferences are read correctly.", obj.equals("<2"));
    }

    public void testURL() throws IOException {
        StringReader in = new StringReader("<java.net.URL id=\"0\">http://www.tagtraum.com:8080/resource?hello=you</java.net.URL>");
        SIXBSReader reader = new SIXBSReader(in, "1.0");
        Object obj = reader.readObject();
        assert("Failed to read URL correctly.", obj.equals(new URL("http://www.tagtraum.com:8080/resource?hello=you")));
    }



    public static TestSuite suite() {
        return new TestSuite(SIXBSReaderTest_1_0.class);
/*
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new SIXBSReaderTest_1_0("testNull"));
        return testSuite;
        */
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
}
