/*

License $Id: SIXBSTest_1_1.java,v 1.1 2001/08/06 16:46:43 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs.test;

import com.tagtraum.sixbs.*;
import junit.framework.*;
import java.io.*;
import java.util.*;
import java.lang.reflect.*;



/**
 *
 *
 * @author 	Hendrik Schreiber
 * @version $Id: SIXBSTest_1_1.java,v 1.1 2001/08/06 16:46:43 Hendrik Exp $
 */
public class SIXBSTest_1_1 extends TestCase {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: SIXBSTest_1_1.java,v 1.1 2001/08/06 16:46:43 Hendrik Exp $";
    
    private StringWriter out;
    private StringReader in;
    private SIXBSWriter writer;
    private SIXBSReader reader;


    public SIXBSTest_1_1(String name) {
        super(name);
    }


    public void setUp() throws IOException {
        out = new StringWriter();
        writer = new SIXBSWriter(out, AdapterFinder.getDefaultAdapterFinder(), true, null, "1.1");
    }
    
    public void tearDown() {
        out = null;
        in = null;
        if (writer != null) try {writer.close();} catch (IOException ioe) {}
        writer = null;
        if (reader != null) reader.close();
        reader = null;
    }

    public void testTestBeanEquality() {
        assert(new TestBean().equals(new TestBean()));
    }

    public void testValidatingParser() throws Exception {
        writer = new SIXBSWriter(out, AdapterFinder.getDefaultAdapterFinder(), false, null, "1.1");
        TestBean bean = new TestBean();
        writer.writeObject(bean);
        in = new StringReader(out.toString());
        reader = new SIXBSReader(in, "1.1");
        reader.setValidating(true);
        Object readObject = reader.readObject();
        assert("Written and read bean are not equal.", bean.equals(readObject));
    }

    public void testEmptyTestBean() throws Exception {
        Object writeObject = new TestBean();
        writer.writeObject(writeObject);
        in = new StringReader(out.toString());
        //System.out.println("testEmptyTestBean()");
        //System.out.println(out.toString());
        reader = new SIXBSReader(in, "1.1");
        Object readObject = reader.readObject();
        
        //out = new StringWriter();
        //writer = new SIXBSWriter(out);
        //writer.writeObject(readObject);
        //System.out.println("read testEmptyTestBean()");
        //System.out.println(out.toString());

        assert("Equals of empty TestBean should return true", writeObject.equals(readObject));
    }

    public void testMultipleEmptyTestBean() throws Exception {
        SIXBSWriter writer = new SIXBSWriter(out, false);
        Object writeObject1 = new TestBean();
        Object writeObject2 = new TestBean();
        writer.writeObject(writeObject1);
        writer.writeObject(writeObject2);
        writer.close();
        in = new StringReader(out.toString());
        /*
        System.out.println("testMultipleEmptyTestBean()");
        System.out.println(out.toString());
        */
        reader = new SIXBSReader(in, "1.1");
        Object readObject1 = reader.readObject();
        Object readObject2 = reader.readObject();
        assert("Failed to read two beans.", writeObject1.equals(readObject1) && writeObject2.equals(readObject2));
    }

    public void testManyTestBeans() throws Exception {
        SIXBSWriter writer = new SIXBSWriter(out);
        ArrayList list = new ArrayList();
        for (int i=0; i<5000; i++) {
            //System.out.print("w");
            //System.out.println("write" + i);
            TestBean tb = new TestBean();
            list.add(tb);
            writer.writeObject(tb);
        }
        writer.close();
        in = new StringReader(out.toString());        
        reader = new SIXBSReader(in, "1.1");
        reader.setReadAhead(500);
        reader.hasNext();
        while (reader.hasNext()) {
            //System.out.print("r");
            TestBean readBean = (TestBean)reader.readObject();
            TestBean writeBean = (TestBean)list.remove(0);
            assert("Many beans failed.", writeBean.equals(readBean));
        }
    }

    public void testTestBeanWithValues() throws Exception {
        TestBean writeObject = new TestBean();
        writeObject.setInteger(-10);
        writeObject.setTwoDimArray(new int[][] {{1,2,3,4,5},{6,7,8,9,0}});
        TestBean intBean = new TestBean();
        intBean.setNullObject(" < &&;; Not null &&;; > ");
        intBean.setTwoDimArray(writeObject.getTwoDimArray());
        writeObject.setTestBean(intBean);
        writer.writeObject(writeObject);
        in = new StringReader(out.toString());
        //System.out.println("testTestBeanWithValues()");
        //System.out.println(out.toString());
        reader = new SIXBSReader(in, "1.1");
        Object readObject = reader.readObject();
        
        out = new StringWriter();
        writer = new SIXBSWriter(out, AdapterFinder.getDefaultAdapterFinder(), true, null, "1.1");
        writer.writeObject(readObject);
        //System.out.println("read testTestBeanWithValues()");
        //System.out.println(out.toString());

        assert("Equals of TestBean should return true", writeObject.equals(readObject));
    }

    public void testTestBeanWithArray() throws Exception {
        TestBean writeObject = new TestBean();
        writeObject.setIntegerArray(new int[] {1,2,3,4,5});
        writer.writeObject(writeObject);
        in = new StringReader(out.toString());
        //System.out.println("testTestBeanWithArray()");
        //System.out.println(out.toString());
        reader = new SIXBSReader(in, "1.1");
        Object readObject = reader.readObject();
        
        out = new StringWriter();
        writer = new SIXBSWriter(out, AdapterFinder.getDefaultAdapterFinder(), true, null, "1.1");
        writer.writeObject(readObject);
        //System.out.println("read testTestBeanWithArray()");
        //System.out.println(out.toString());

        assert("Equals of TestBean should return true", writeObject.equals(readObject));
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(SIXBSTest_1_1.class);
        return testSuite;
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
}