/*

License $Id: SIXBSWriterTest_1_0.java,v 1.1 2001/08/05 21:50:50 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs.test;

import com.tagtraum.sixbs.*;
import junit.framework.*;
import java.io.*;
import java.util.*;
import java.net.*;

/**
 *
 *
 * @author 	Hendrik Schreiber
 * @version $Id: SIXBSWriterTest_1_0.java,v 1.1 2001/08/05 21:50:50 Hendrik Exp $
 */
public class SIXBSWriterTest_1_0 extends TestCase {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: SIXBSWriterTest_1_0.java,v 1.1 2001/08/05 21:50:50 Hendrik Exp $";
    
    private CharArrayWriter out;
    private SIXBSWriter writer;
    
    public SIXBSWriterTest_1_0(String name) {
        super(name);
    }
    
    public void setUp() throws IOException {
        out = new CharArrayWriter();
        writer = new SIXBSWriter(out, AdapterFinder.getDefaultAdapterFinder(), true, null, "1.0");
    }
    
    public void tearDown() {
        out = null;
        writer = null;
    }
    
    public void testObject() throws IOException {
        Object obj = new Object();
        writer.writeObject(obj);
        //System.out.println(out.toString());
        assert("Make sure, simple object is written correctly.", out.toString().equals("<java.lang.Object id=\"0\"></java.lang.Object>"));
    }
    
    public void testEmptyString() throws IOException {
        Object obj = new String();
        writer.writeObject(obj);
        //System.out.println(out.toString());
        assert("Make sure, empty String is written correctly.", out.toString().equals("<java.lang.String id=\"0\"></java.lang.String>"));
    }

    public void testSimpleString() throws IOException {
        Object obj = new String("tagtraum rulez!");
        writer.writeObject(obj);
        //System.out.println(out.toString());
        assert("Make sure, simple String is written correctly.", out.toString().equals("<java.lang.String id=\"0\">tagtraum rulez!</java.lang.String>"));
    }

    public void testBoolean() throws IOException {
        Object obj = new Boolean(true);
        writer.writeObject(obj);
        //System.out.println(out.toString());
        assert("Make sure, Boolean is written correctly.", out.toString().equals("<java.lang.Boolean id=\"0\">true</java.lang.Boolean>"));
    }

    public void testFloat() throws IOException {
        Object obj = new Float(1.4);
        writer.writeObject(obj);
        //System.out.println(out.toString());
        assert("Make sure, Float is written correctly.", out.toString().equals("<java.lang.Float id=\"0\">1.4</java.lang.Float>"));
    }

    public void testNull() throws IOException {
        writer.writeObject(null);
        //System.out.println(out.toString());
        assert("Make sure, Null is written correctly.", out.toString().equals("<com.tagtraum.sixbs.Null id=\"0\"></com.tagtraum.sixbs.Null>"));
    }

    public void testURL() throws IOException {
        writer.writeObject(new URL("http://www.tagtraum.com:8080/resource?hello=you"));
        //System.out.println(out.toString());
        assert("Failed to write URL correctly.", out.toString().equals("<java.net.URL id=\"0\">http://www.tagtraum.com:8080/resource?hello=you</java.net.URL>"));
    }

    public static TestSuite suite() {
        return new TestSuite(SIXBSWriterTest_1_0.class);
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
}