/*

License $Id: TestBean.java,v 1.2 2001/08/06 16:46:43 Hendrik Exp $

Copyright (c) 2001 tagtraum industries.

The sixbs library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For LGPL see <http://www.fsf.org/copyleft/lesser.txt>

We encourage your feedback and suggestions and want to use your feedback to
improve the Software. Send all such feedback to:
feedback@tagtraum.com

For more information on tagtraum industries, Hendrik Schreiber and sixbs
please see <http://www.tagtraum.com/>.

*/

package com.tagtraum.sixbs.test;

import java.util.*;
import com.tagtraum.sixbs.*;


/**
 * 
 * 
 * @author 	Hendrik Schreiber
 * @version $Id: TestBean.java,v 1.2 2001/08/06 16:46:43 Hendrik Exp $
 */
public class TestBean implements SIXBSSerializable {

    /**
     * Source-Version
     */
    public static String	vcid = 
	"$Id: TestBean.java,v 1.2 2001/08/06 16:46:43 Hendrik Exp $";
    
    private TestBean testBean;
    private int integer;
    private int[] integerArray;
    private int[][] twoDimArray;
    private Object nullObject;
    
    public void setTestBean(TestBean testBean) {
        this.testBean = testBean;
    }

    public TestBean getTestBean() {
        return testBean;
    }
    
    public void setInteger(int integer) {
        this.integer = integer;
    }

    public int getInteger() {
        return integer;
    }

    public void setIntegerArray(int[] integerArray) {
        this.integerArray = integerArray;
    }

    public int[] getIntegerArray() {
        return integerArray;
    }

    public void setTwoDimArray(int[][] twoDimArray) {
        this.twoDimArray = twoDimArray;
    }

    public int[][] getTwoDimArray() {
        return twoDimArray;
    }

    public void setNullObject(Object nullObject) {
        this.nullObject = nullObject;
    }

    public Object getNullObject() {
        return nullObject;
    }

    public Object getOnlyGetMethod() {
        return null;
    }

    public void setOnlySetMethod() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TestBean)) return false;
        TestBean tb =(TestBean)obj;
        
        if (integer != tb.getInteger()) {
            System.out.println("integer: " + integer + " != " + tb.getInteger());
            return false;
        }
        if ((nullObject != tb.getNullObject() && (nullObject == null && !nullObject.equals(tb.getNullObject())))) {
            System.out.println("nullObject: " + nullObject + " != " + tb.getNullObject());
            return false;
        }
        
        if ((testBean != tb.getTestBean() && (testBean == null || !testBean.equals(tb.getTestBean())))) {
            System.out.println("testBean: " + testBean + " != " + tb.getTestBean());
            return false;
        }
        
        if (!java.util.Arrays.equals(integerArray, tb.getIntegerArray())) {
            System.out.println("Length integerArray: " + integerArray.length);
            System.out.println("Length getIntegerArray(): " + tb.getIntegerArray().length);
            for (int i=0; i<integerArray.length; i++) {
                System.out.println(integerArray[i] + " : " + tb.getIntegerArray()[i]);
            }
            
            System.out.println("integerArray: " + integerArray + " != " + tb.getIntegerArray());
            return false;
        }

        if (!equals(twoDimArray, tb.getTwoDimArray())) {
            System.out.println("Length twoDimArray: " + twoDimArray.length);
            System.out.println("Length getTwoDimArray(): " + tb.getTwoDimArray().length);
            for (int i=0; i<twoDimArray.length; i++) {
                for (int j=0; j<twoDimArray[i].length; j++) {
                    System.out.println(twoDimArray[i][j] + " : " + tb.getTwoDimArray()[i][j]);
                }
            }

            System.out.println("twoDimArray: " + twoDimArray + " != " + tb.getTwoDimArray());
            return false;
        }
        return true;
        
        /*
        return 
            integer == tb.getInteger()
            && (nullObject == tb.getNullObject() || (nullObject != null && nullObject.equals(tb.getNullObject())))
            && (testBean == tb.getTestBean() || (testBean != null && testBean.equals(tb.getTestBean())))
            && java.util.Arrays.equals(integerArray, tb.getIntegerArray());
        */
    }
    
    public Collection getCollection() {
        return new ArrayList();
    }
    
    public void setCollection(Collection c) {
    }
    
    public boolean serializable(String propertyname) {
        return !propertyname.equals("collection");
    }

    public static boolean equals(int[][] i1, int[][] i2) {
        if (i1==i2) return true;
        if (i1==null || i2==null) return false;
        if (i1.length != i2.length) return false;
        for (int i=0; i<i1.length; i++) {
            if (i1[i] != i2[i]) {
                if (i1[i]==null || i2[i]==null) return false;
                if (i1[i].length != i2[i].length) return false;
                for (int j=0; j<i1[i].length; j++) {
                    if (i1[i][j] != i2[i][j]) return false;
                }
            }
        }
        return true;
    }

}
